/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.gui.journal;

import com.InfinityRaider.AgriCraft.api.v1.BlockWithMeta;
import com.InfinityRaider.AgriCraft.api.v1.IMutation;
import com.InfinityRaider.AgriCraft.farming.CropPlantHandler;
import com.InfinityRaider.AgriCraft.farming.cropplant.CropPlant;
import com.InfinityRaider.AgriCraft.farming.mutation.MutationHandler;
import com.InfinityRaider.AgriCraft.gui.Component;
import com.InfinityRaider.AgriCraft.gui.journal.JournalPage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

@SideOnly(value=Side.CLIENT)
public class JournalPageSeed
extends JournalPage {
    private static final ResourceLocation ICON_FRAME = new ResourceLocation("AgriCraft".toLowerCase(), "textures/gui/journal/GuiJournalSeedFrame.png");
    private static final ResourceLocation MUTATION_TEMPLATE = new ResourceLocation("AgriCraft".toLowerCase(), "textures/gui/journal/GuiJournalMutationTemplate.png");
    private static final ResourceLocation QUESTION_MARK = new ResourceLocation("AgriCraft".toLowerCase(), "textures/gui/journal/GuiJournalQuestionMark.png");
    private static final ResourceLocation BRIGHTNESS_BAR = new ResourceLocation("AgriCraft".toLowerCase(), "textures/gui/journal/GuiJournalBrightnessBar.png");
    private static final ResourceLocation BRIGHTNESS_FRAME = new ResourceLocation("AgriCraft".toLowerCase(), "textures/gui/journal/GuiJournalBrightnessFrame.png");
    private ArrayList<ItemStack> discoveredSeeds;
    private int page;
    private CropPlant plant;
    private ArrayList<Component<ItemStack>> fruits;
    private ArrayList<Component<ItemStack>> seeds;

    public JournalPageSeed(ArrayList<ItemStack> discoveredSeeds, int page) {
        this.discoveredSeeds = discoveredSeeds;
        this.page = page;
        this.plant = CropPlantHandler.getPlantFromStack(discoveredSeeds.get(page));
        this.fruits = this.getFruits();
        this.seeds = this.getSeeds();
    }

    @Override
    public ResourceLocation getForeground() {
        return new ResourceLocation("AgriCraft".toLowerCase(), "textures/gui/journal/GuiJournalSeedPage.png");
    }

    @Override
    public ArrayList<String> getTooltip(int x, int y) {
        for (Component<ItemStack> component : this.fruits) {
            if (!component.isOverComponent(x, y)) continue;
            ArrayList<String> toolTip = new ArrayList<String>();
            toolTip.add(component.getComponent().func_82833_r());
            return toolTip;
        }
        for (Component<ItemStack> component : this.seeds) {
            if (!component.isOverComponent(x, y)) continue;
            ArrayList<String> toolTip = new ArrayList<String>();
            toolTip.add(component.getComponent().func_82833_r());
            return toolTip;
        }
        return null;
    }

    @Override
    public int getPagesToBrowseOnMouseClick(int x, int y) {
        for (Component<ItemStack> component : this.seeds) {
            if (!component.isOverComponent(x, y)) continue;
            ItemStack selected = component.getComponent();
            for (int i = 0; i < this.discoveredSeeds.size(); ++i) {
                ItemStack current = this.discoveredSeeds.get(i);
                if (selected.func_77973_b() != current.func_77973_b() || selected.func_77960_j() != current.func_77960_j()) continue;
                return i - this.page;
            }
        }
        return 0;
    }

    @Override
    public ArrayList<Component<String>> getTextComponents() {
        ArrayList<Component<String>> textComponents = new ArrayList<Component<String>>();
        textComponents.add(this.getTitle());
        textComponents.add(this.getDescriptionHead());
        textComponents.add(this.getSeedInformation());
        textComponents.add(this.getTier());
        textComponents.add(this.getBrightnessTitle());
        textComponents.add(this.getFruitTitle());
        textComponents.add(this.getGrowthTitle());
        textComponents.addAll(this.getMutationTitles());
        return textComponents;
    }

    private Component<String> getTitle() {
        String text = this.plant.getSeed().func_82833_r();
        int x = 82;
        int y = 17;
        float scale = 0.8f;
        while ((float)Minecraft.func_71410_x().field_71466_p.func_78256_a(text) * scale > 74.0f) {
            scale -= 0.1f;
        }
        return new Component<String>(text, x, y, scale, true);
    }

    private Component<String> getDescriptionHead() {
        String text = StatCollector.func_74838_a((String)"agricraft_journal.information") + ": ";
        int x = 29;
        int y = 31;
        float scale = 0.5f;
        return new Component<String>(text, x, y, scale);
    }

    private Component<String> getSeedInformation() {
        String text = StatCollector.func_74838_a((String)this.plant.getInformation());
        int x = 29;
        int y = 38;
        float scale = 0.5f;
        return new Component<String>(text, x, y, scale);
    }

    private Component<String> getTier() {
        String text = StatCollector.func_74838_a((String)"agricraft_journal.tier") + ": " + this.plant.getTier();
        int x = 29;
        int y = 66;
        float scale = 0.5f;
        return new Component<String>(text, x, y, scale);
    }

    private Component<String> getBrightnessTitle() {
        String text = StatCollector.func_74838_a((String)"agricraft_journal.brightness") + ": ";
        int x = 29;
        int y = 76;
        float scale = 0.5f;
        return new Component<String>(text, x, y, scale);
    }

    private Component<String> getFruitTitle() {
        String text = StatCollector.func_74838_a((String)"agricraft_journal.fruits") + ": ";
        int x = 29;
        int y = 95;
        float scale = 0.5f;
        return new Component<String>(text, x, y, scale);
    }

    private Component<String> getGrowthTitle() {
        String text = StatCollector.func_74838_a((String)"agricraft_journal.growthStages") + ": ";
        int x = 29;
        int y = 122;
        float scale = 0.5f;
        return new Component<String>(text, x, y, scale);
    }

    private ArrayList<Component<String>> getMutationTitles() {
        String text = StatCollector.func_74838_a((String)"agricraft_journal.mutations") + ": ";
        int x = 132;
        int y = 13;
        float scale = 0.5f;
        ArrayList<Component<String>> list = new ArrayList<Component<String>>();
        list.add(new Component<String>(text, x, y, scale));
        return list;
    }

    @Override
    public ArrayList<Component<ItemStack>> getItemComponents() {
        ArrayList<Component<ItemStack>> itemComponents = new ArrayList<Component<ItemStack>>();
        itemComponents.add(this.getSeed());
        itemComponents.addAll(this.fruits);
        itemComponents.addAll(this.seeds);
        return itemComponents;
    }

    private Component<ItemStack> getSeed() {
        ItemStack stack = this.plant.getSeed();
        int x = 26;
        int y = 11;
        return new Component<ItemStack>(stack, x, y);
    }

    private ArrayList<Component<ItemStack>> getFruits() {
        if (this.plant == null) {
            this.plant = CropPlantHandler.getPlantFromStack(this.discoveredSeeds.get(this.page));
        }
        ArrayList<Component<ItemStack>> fruits = new ArrayList<Component<ItemStack>>();
        ArrayList<ItemStack> allFruits = this.plant.getAllFruits();
        if (allFruits != null) {
            for (int i = 0; i < allFruits.size(); ++i) {
                ItemStack stack = allFruits.get(i);
                if (stack == null || stack.func_77973_b() == null) continue;
                int x = 30 + 24 * i;
                int y = 102;
                fruits.add(new Component<ItemStack>(stack, x, y, 16, 16));
            }
        }
        return fruits;
    }

    private ArrayList<Component<ItemStack>> getSeeds() {
        ArrayList<IMutation> completedMutations = this.getCompletedMutations();
        ArrayList<IMutation> uncompletedMutations = this.getUncompleteMutations();
        ArrayList<Component<ItemStack>> seeds = new ArrayList<Component<ItemStack>>();
        int y = 1;
        int x = 132;
        for (IMutation mutation : completedMutations) {
            ItemStack resultStack = mutation.getResult();
            ItemStack parent1Stack = mutation.getParents()[0];
            ItemStack parent2Stack = mutation.getParents()[1];
            seeds.add(new Component<ItemStack>(parent1Stack, x, y += 20, 16, 16));
            seeds.add(new Component<ItemStack>(parent2Stack, x + 35, y, 16, 16));
            seeds.add(new Component<ItemStack>(resultStack, x + 69, y, 16, 16));
        }
        for (IMutation mutation : uncompletedMutations) {
            ItemStack parent1Stack = mutation.getParents()[0];
            ItemStack parent2Stack = mutation.getParents()[1];
            seeds.add(new Component<ItemStack>(parent1Stack, x, y += 20, 16, 16));
            seeds.add(new Component<ItemStack>(parent2Stack, x + 35, y, 16, 16));
        }
        return seeds;
    }

    private ArrayList<IMutation> getCompletedMutations() {
        ArrayList<IMutation> mutations = this.getDiscoveredParentMutations();
        mutations.addAll(this.getDiscoveredChildMutations());
        return mutations;
    }

    private ArrayList<IMutation> getDiscoveredParentMutations() {
        ArrayList<IMutation> allMutations = new ArrayList<IMutation>();
        ArrayList<IMutation> mutations = new ArrayList<IMutation>();
        allMutations.addAll(Arrays.asList(MutationHandler.getInstance().getMutationsFromParent(this.discoveredSeeds.get(this.page))));
        for (IMutation mutation : allMutations) {
            if (!this.isMutationDiscovered(mutation)) continue;
            mutations.add(mutation);
        }
        return mutations;
    }

    private ArrayList<IMutation> getDiscoveredChildMutations() {
        ArrayList<IMutation> allMutations = new ArrayList<IMutation>();
        ArrayList<IMutation> mutations = new ArrayList<IMutation>();
        allMutations.addAll(Arrays.asList(MutationHandler.getInstance().getMutationsFromChild(this.discoveredSeeds.get(this.page))));
        for (IMutation mutation : allMutations) {
            if (!this.isMutationDiscovered(mutation)) continue;
            mutations.add(mutation);
        }
        return mutations;
    }

    private ArrayList<IMutation> getUncompleteMutations() {
        ArrayList<IMutation> allMutations = new ArrayList<IMutation>();
        ArrayList<IMutation> mutations = new ArrayList<IMutation>();
        allMutations.addAll(Arrays.asList(MutationHandler.getInstance().getMutationsFromParent(this.discoveredSeeds.get(this.page))));
        for (IMutation mutation : allMutations) {
            if (!this.isMutationHalfDiscovered(mutation)) continue;
            mutations.add(mutation);
        }
        return mutations;
    }

    private boolean isMutationDiscovered(IMutation mutation) {
        ItemStack resultStack = mutation.getResult();
        return this.areParentsDiscovered(mutation) && this.isSeedDiscovered(resultStack);
    }

    private boolean isMutationHalfDiscovered(IMutation mutation) {
        ItemStack resultStack = mutation.getResult();
        return this.areParentsDiscovered(mutation) && !this.isSeedDiscovered(resultStack);
    }

    private boolean areParentsDiscovered(IMutation mutation) {
        ItemStack parent1Stack = mutation.getParents()[0];
        ItemStack parent2Stack = mutation.getParents()[1];
        return this.isSeedDiscovered(parent1Stack) && this.isSeedDiscovered(parent2Stack);
    }

    private boolean isSeedDiscovered(ItemStack seed) {
        for (ItemStack current : this.discoveredSeeds) {
            if (current.func_77973_b() != seed.func_77973_b() || current.func_77960_j() != seed.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<Component<ResourceLocation>> getTextureComponents() {
        ArrayList<Component<ResourceLocation>> textureComponents = new ArrayList<Component<ResourceLocation>>();
        textureComponents.add(this.getSoil());
        textureComponents.addAll(this.getBrightnessTextures());
        textureComponents.addAll(this.getFruitIconFrames());
        textureComponents.addAll(this.getMutationTemplates());
        return textureComponents;
    }

    private Component<ResourceLocation> getSoil() {
        ItemStack seed = this.plant.getSeed();
        BlockWithMeta soil = CropPlantHandler.getGrowthRequirement(seed.func_77973_b(), seed.func_77960_j()).getSoil();
        ResourceLocation texture = soil != null ? this.getBlockResource(soil.getBlock().func_149691_a(1, soil.getMeta())) : this.getBlockResource(Blocks.field_150458_ak.func_149691_a(1, 7));
        int x = 26;
        int y = 11;
        return new Component<ResourceLocation>(texture, x, y, 16, 16);
    }

    private ResourceLocation getBlockResource(IIcon icon) {
        if (icon == null) {
            return null;
        }
        String path = icon.func_94215_i();
        String domain = path.substring(0, path.indexOf(":") + 1);
        String file = path.substring(path.indexOf(58) + 1);
        return new ResourceLocation(domain + "textures/blocks/" + file + ".png");
    }

    private ArrayList<Component<ResourceLocation>> getBrightnessTextures() {
        ArrayList<Component<ResourceLocation>> textures = new ArrayList<Component<ResourceLocation>>();
        int x = 29;
        int y = 81;
        int u = 4;
        int v = 8;
        int[] brightnessRange = this.plant.getGrowthRequirement().getBrightnessRange();
        textures.add(new Component<ResourceLocation>(BRIGHTNESS_BAR, x, y, 2 + 16 * u, v));
        textures.add(new Component<ResourceLocation>(BRIGHTNESS_FRAME, x + u * brightnessRange[0], y, 1, v));
        textures.add(new Component<ResourceLocation>(BRIGHTNESS_FRAME, x + u * brightnessRange[1] + 1, y, 1, v));
        textures.add(new Component<ResourceLocation>(BRIGHTNESS_FRAME, x + u * brightnessRange[0] + 1, y, u * (brightnessRange[1] - brightnessRange[0]), 1));
        textures.add(new Component<ResourceLocation>(BRIGHTNESS_FRAME, x + u * brightnessRange[0] + 1, y + v - 1, u * (brightnessRange[1] - brightnessRange[0]), 1));
        return textures;
    }

    private ArrayList<Component<ResourceLocation>> getFruitIconFrames() {
        if (this.fruits == null) {
            this.fruits = this.getFruits();
        }
        ArrayList<Component<ResourceLocation>> components = new ArrayList<Component<ResourceLocation>>();
        for (int i = 0; i < this.fruits.size(); ++i) {
            components.add(new Component<ResourceLocation>(ICON_FRAME, 29 + 24 * i, 101, 18, 18));
        }
        return components;
    }

    private ArrayList<Component<ResourceLocation>> getMutationTemplates() {
        int i;
        int n = this.getCompletedMutations().size();
        int l = this.getUncompleteMutations().size();
        ArrayList<Component<ResourceLocation>> components = new ArrayList<Component<ResourceLocation>>();
        int y = 0;
        for (i = 0; i < n; ++i) {
            components.add(new Component<ResourceLocation>(MUTATION_TEMPLATE, 132, y += 20, 86, 18));
        }
        for (i = 0; i < l; ++i) {
            components.add(new Component<ResourceLocation>(MUTATION_TEMPLATE, 132, y += 20, 86, 18));
            components.add(new Component<ResourceLocation>(QUESTION_MARK, 201, y + 1, 16, 16));
        }
        return components;
    }

    @Override
    public ArrayList<ResourceLocation> getTextureMaps() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        list.add(TextureMap.field_110575_b);
        return list;
    }

    @Override
    public ArrayList<Component<IIcon>> getIconComponents(ResourceLocation textureMap) {
        if (textureMap != TextureMap.field_110575_b) {
            return null;
        }
        return this.getGrowthStageIcons();
    }

    private ArrayList<Component<IIcon>> getGrowthStageIcons() {
        ArrayList<Component<IIcon>> growthStages = new ArrayList<Component<IIcon>>();
        for (int i = 0; i < 8; ++i) {
            int x = 30 + 24 * (i % 4);
            int y = 129 + 24 * (i / 4);
            growthStages.add(new Component<IIcon>(this.plant.getPlantIcon(i), x, y, 16, 16));
        }
        return growthStages;
    }
}

