/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.forestry.handlers;

import forestry.api.recipes.ISqueezerManager;
import forestry.api.recipes.ISqueezerRecipe;
import forestry.api.recipes.RecipeManagers;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.WeightedItemStack;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.forestry.ForestryListAddition;
import modtweaker2.mods.forestry.ForestryListRemoval;
import modtweaker2.mods.forestry.recipes.SqueezerRecipe;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.Squeezer")
public class Squeezer {
    public static final String name = "Forestry Squeezer";

    @ZenMethod
    public static void addRecipe(ILiquidStack fluidOutput, int timePerItem, IItemStack[] ingredients) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new SqueezerRecipe(timePerItem, InputHelper.toStacks(ingredients), InputHelper.toFluid(fluidOutput), null, 0.0f)));
    }

    @ZenMethod
    public static void addRecipe(ILiquidStack fluidOutput, WeightedItemStack itemOutput, IItemStack[] ingredients, int timePerItem) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new SqueezerRecipe(timePerItem, InputHelper.toStacks(ingredients), InputHelper.toFluid(fluidOutput), InputHelper.toStack(itemOutput.getStack()), itemOutput.getChance())));
    }

    @ZenMethod
    @Deprecated
    public static void addRecipe(int timePerItem, IItemStack[] resources, ILiquidStack liquid, IItemStack remnants, int chance) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new SqueezerRecipe(timePerItem, InputHelper.toStacks(resources), InputHelper.toFluid(liquid), InputHelper.toStack(remnants), chance)));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient liquid, @Optional IIngredient[] ingredients) {
        LinkedList<ISqueezerRecipe> recipes = new LinkedList<ISqueezerRecipe>();
        for (ISqueezerRecipe r : RecipeManagers.squeezerManager.recipes()) {
            if (r == null || r.getFluidOutput() == null || !StackHelper.matches(liquid, InputHelper.toILiquidStack(r.getFluidOutput()))) continue;
            if (ingredients != null) {
                boolean matched = false;
                for (int i = 0; i < ingredients.length; ++i) {
                    if (!StackHelper.matches(ingredients[i], InputHelper.toIItemStack(r.getResources()[i]))) {
                        matched = false;
                        break;
                    }
                    matched = true;
                }
                if (!matched) continue;
                recipes.add(r);
                continue;
            }
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, LogHelper.getStackDescription(liquid)));
        }
    }

    private static class Remove
    extends ForestryListRemoval<ISqueezerRecipe, ISqueezerManager> {
        public Remove(List<ISqueezerRecipe> recipes) {
            super(Squeezer.name, RecipeManagers.squeezerManager, recipes);
        }

        @Override
        public String getRecipeInfo(ISqueezerRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getFluidOutput());
        }
    }

    private static class Add
    extends ForestryListAddition<ISqueezerRecipe, ISqueezerManager> {
        public Add(ISqueezerRecipe recipe) {
            super(Squeezer.name, RecipeManagers.squeezerManager);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(ISqueezerRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getFluidOutput());
        }
    }
}

