/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.widgets;

import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

public class TabbedPanel
extends AbstractContainerWidget<Panel> {
    private Widget current = null;
    private Map<String, Widget> pages = new HashMap<String, Widget>();

    public TabbedPanel(Minecraft mc, Gui gui) {
        super(mc, gui);
    }

    public TabbedPanel addPage(String name, Widget child) {
        this.addChild(child);
        this.pages.put(name, child);
        return this;
    }

    public Widget getCurrent() {
        return this.current;
    }

    public String getCurrentName() {
        for (Map.Entry<String, Widget> me : this.pages.entrySet()) {
            if (this.current != me.getValue()) continue;
            return me.getKey();
        }
        return null;
    }

    public TabbedPanel setCurrent(Widget current) {
        this.current = current;
        return this;
    }

    public TabbedPanel setCurrent(String name) {
        this.current = this.pages.get(name);
        return this;
    }

    @Override
    public Widget getWidgetAtPosition(int x, int y) {
        return this.current == null ? this : this.current;
    }

    @Override
    public void draw(Window window, int x, int y) {
        if (!this.visible) {
            return;
        }
        super.draw(window, x, y);
        int xx = x + this.bounds.x;
        int yy = y + this.bounds.y;
        this.drawBox(xx, yy, -65536);
        if (this.isDirty()) {
            for (Widget child : this.children) {
                child.setBounds(new Rectangle(0, 0, this.getBounds().width, this.getBounds().height));
            }
            this.markClean();
        }
        if (this.current != null) {
            this.current.draw(window, xx, yy);
        }
    }

    @Override
    public Widget mouseClick(Window window, int x, int y, int button) {
        super.mouseClick(window, x, y, button);
        if (this.current != null && this.current.in(x -= this.bounds.x, y -= this.bounds.y) && this.current.isVisible()) {
            return this.current.mouseClick(window, x, y, button);
        }
        return null;
    }

    @Override
    public void mouseRelease(int x, int y, int button) {
        super.mouseRelease(x, y, button);
        x -= this.bounds.x;
        y -= this.bounds.y;
        if (this.current != null) {
            this.current.mouseRelease(x, y, button);
        }
    }

    @Override
    public void mouseMove(int x, int y) {
        super.mouseMove(x, y);
        x -= this.bounds.x;
        y -= this.bounds.y;
        if (this.current != null) {
            this.current.mouseMove(x, y);
        }
    }
}

