/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.position;

import cofh.lib.util.position.BlockPosition;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.AxisAlignedBB;

public class Area {
    public int xMin;
    public int xMax;
    public int yMin;
    public int yMax;
    public int zMin;
    public int zMax;
    private BlockPosition origin;

    public Area(int xMin, int xMax, int yMin, int yMax, int zMin, int zMax) {
        this.xMin = xMin;
        this.xMax = xMax;
        this.yMin = yMin;
        this.yMax = yMax;
        this.zMin = zMin;
        this.zMax = zMax;
    }

    public Area(BlockPosition center, int radius, int yNegOffset, int yPosOffset) {
        this.xMin = center.x - radius;
        this.xMax = center.x + radius;
        this.yMin = center.y - yNegOffset;
        this.yMax = center.y + yPosOffset;
        this.zMin = center.z - radius;
        this.zMax = center.z + radius;
        this.origin = center;
    }

    public BlockPosition getMin() {
        return new BlockPosition(this.xMin, this.yMin, this.zMin);
    }

    public BlockPosition getMax() {
        return new BlockPosition(this.xMax, this.yMax, this.zMax);
    }

    public boolean contains(BlockPosition pos) {
        return pos.x >= this.xMin & pos.x <= this.xMax & pos.y >= this.yMin & pos.y <= this.yMax & pos.z >= this.zMin & pos.z <= this.zMax;
    }

    public List<BlockPosition> getPositionsTopFirst() {
        ArrayList<BlockPosition> positions = new ArrayList<BlockPosition>();
        for (int y = this.yMax; y >= this.yMin; --y) {
            for (int x = this.xMin; x <= this.xMax; ++x) {
                for (int z = this.zMin; z <= this.zMax; ++z) {
                    positions.add(new BlockPosition(x, y, z));
                }
            }
        }
        return positions;
    }

    public List<BlockPosition> getPositionsBottomFirst() {
        ArrayList<BlockPosition> positions = new ArrayList<BlockPosition>();
        for (int y = this.yMin; y <= this.yMax; ++y) {
            for (int x = this.xMin; x <= this.xMax; ++x) {
                for (int z = this.zMin; z <= this.zMax; ++z) {
                    positions.add(new BlockPosition(x, y, z));
                }
            }
        }
        return positions;
    }

    public BlockPosition getOrigin() {
        return this.origin.copy();
    }

    public AxisAlignedBB toAxisAlignedBB() {
        return AxisAlignedBB.func_72330_a((double)this.xMin, (double)this.yMin, (double)this.zMin, (double)(this.xMax + 1), (double)(this.yMax + 1), (double)(this.zMax + 1));
    }
}

