/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world;

import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.WorldGenMinableCluster;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenBoulder
extends WorldGenerator {
    private final List<WeightedRandomBlock> cluster;
    private final WeightedRandomBlock[] genBlock;
    private final int size;
    public int sizeVariance = 2;
    public int clusters = 3;
    public int clusterVariance = 0;
    public boolean hollow = false;
    public float hollowAmt = 0.1665f;
    public float hollowVar = 0.0f;

    public WorldGenBoulder(List<WeightedRandomBlock> resource, int minSize, List<WeightedRandomBlock> block) {
        this.cluster = resource;
        this.size = minSize;
        this.genBlock = block.toArray(new WeightedRandomBlock[block.size()]);
    }

    public boolean func_76484_a(World world, Random rand, int xCenter, int yCenter, int zCenter) {
        int i;
        int minSize = this.size;
        int var = this.sizeVariance;
        boolean r = false;
        int n = i = this.clusterVariance > 0 ? this.clusters + rand.nextInt(this.clusterVariance + 1) : this.clusters;
        while (i-- > 0) {
            while (yCenter > minSize && world.func_147437_c(xCenter, yCenter - 1, zCenter)) {
                --yCenter;
            }
            if (yCenter <= minSize + var + 1) {
                return false;
            }
            if (WorldGenMinableCluster.canGenerateInBlock(world, xCenter, yCenter - 1, zCenter, this.genBlock)) {
                int xWidth = minSize + (var > 1 ? rand.nextInt(var) : 0);
                int yWidth = minSize + (var > 1 ? rand.nextInt(var) : 0);
                int zWidth = minSize + (var > 1 ? rand.nextInt(var) : 0);
                float maxDist = (float)(xWidth + yWidth + zWidth) * 0.333f + 0.5f;
                maxDist *= maxDist;
                float minDist = this.hollow ? (float)(xWidth + yWidth + zWidth) * (this.hollowAmt * (1.0f - rand.nextFloat() * this.hollowVar)) : 0.0f;
                minDist *= minDist;
                for (int x = -xWidth; x <= xWidth; ++x) {
                    int xDist = x * x;
                    for (int z = -zWidth; z <= zWidth; ++z) {
                        int xzDist = xDist + z * z;
                        for (int y = -yWidth; y <= yWidth; ++y) {
                            int dist = xzDist + y * y;
                            if (!((float)dist <= maxDist)) continue;
                            if ((float)dist >= minDist) {
                                r |= WorldGenMinableCluster.generateBlock(world, xCenter + x, yCenter + y, zCenter + z, this.cluster);
                                continue;
                            }
                            r |= world.func_147468_f(xCenter + x, yCenter + y, zCenter + z);
                        }
                    }
                }
            }
            xCenter += rand.nextInt(var + minSize * 2) - (minSize + var / 2);
            zCenter += rand.nextInt(var + minSize * 2) - (minSize + var / 2);
            yCenter += rand.nextInt((var + 1) * 3) - (var + 1);
        }
        return r;
    }
}

