/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world;

import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.WorldGenMinableCluster;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S21PacketChunkData;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenMassiveTree
extends WorldGenerator {
    private static final byte[] otherCoordPairs = new byte[]{2, 0, 0, 1, 2, 1};
    private static final float PI = (float)Math.PI;
    private Random rand = new Random();
    private World worldObj;
    private int[][] leafNodes;
    private int[] basePos = new int[]{0, 0, 0};
    private int heightLimit = 0;
    private int height;
    private int leafBases;
    private int leafNodesLength;
    private int density;
    private final List<WeightedRandomBlock> leaves;
    private final List<WeightedRandomBlock> trunk;
    private final WeightedRandomBlock[] genBlock;
    private boolean generated = false;
    public boolean smoothLogs = false;
    public boolean slopeTrunk = false;
    public boolean safeGrowth = true;
    public boolean treeChecks = true;
    public boolean fastPlacement = false;
    public boolean relightBlocks = true;
    public WeightedRandomBlock[] genSurface = null;
    public int minHeight = -1;
    public int leafDistanceLimit = 4;
    public int heightLimitLimit = 250;
    public float heightAttenuation = 0.45f;
    public float branchDensity = 1.0f;
    public float branchSlope = 0.381f;
    public float scaleWidth = 1.0f;
    public int trunkSize = 11;
    private int[] placeScratch = new int[3];
    private int[] checkScratch = new int[3];
    private TLongObjectHashMap<Chunk> chunkMap;

    public WorldGenMassiveTree(List<WeightedRandomBlock> resource, List<WeightedRandomBlock> leaf, List<WeightedRandomBlock> block) {
        super(false);
        this.trunk = resource;
        this.leaves = leaf;
        this.genBlock = block.toArray(new WeightedRandomBlock[block.size()]);
    }

    private void setup() {
        this.leafBases = MathHelper.func_76123_f((float)((float)this.heightLimit * this.heightAttenuation));
        this.density = Math.max(1, (int)(1.382 + Math.pow((double)(this.branchDensity * (float)this.heightLimit) / 13.0, 2.0)));
        this.chunkMap = new TLongObjectHashMap((int)(this.scaleWidth * (float)this.heightLimit));
    }

    private float layerSize(int par1) {
        float var4;
        if (par1 < this.leafBases) {
            return -1.618f;
        }
        float var2 = (float)this.heightLimit * 0.5f;
        float var3 = (float)this.heightLimit * 0.5f - (float)par1;
        if (var3 == 0.0f) {
            var4 = var2;
        } else {
            if (Math.abs(var3) >= var2) {
                return 0.0f;
            }
            var4 = (float)Math.sqrt(var2 * var2 - var3 * var3);
        }
        return var4 *= 0.5f;
    }

    private void generateLeafNodeList() {
        int var1 = this.density;
        int[] basePos = this.basePos;
        int[][] var2 = new int[var1 * this.heightLimit][4];
        int var3 = basePos[1] + this.heightLimit - this.leafDistanceLimit;
        int var4 = 1;
        int var5 = basePos[1] + this.height;
        int var6 = var3 - basePos[1];
        var2[0][0] = basePos[0];
        var2[0][1] = var3--;
        var2[0][2] = basePos[2];
        var2[0][3] = var5;
        while (var6 >= 0) {
            float var8 = this.layerSize(var6);
            if (var8 > 0.0f) {
                float var9 = 0.5f;
                for (int var7 = 0; var7 < var1; ++var7) {
                    float var11 = this.scaleWidth * var8 * (this.rand.nextFloat() + 0.328f);
                    float var13 = this.rand.nextFloat() * 2.0f * (float)Math.PI;
                    int var15 = MathHelper.func_76128_c((double)((double)var11 * Math.sin(var13) + (double)basePos[0] + (double)var9));
                    int var16 = MathHelper.func_76128_c((double)((double)var11 * Math.cos(var13) + (double)basePos[2] + (double)var9));
                    int[] var17 = new int[]{var15, var3, var16};
                    int[] var18 = new int[]{var15, var3 + this.leafDistanceLimit, var16};
                    if (this.checkBlockLine(var17, var18) != -1) continue;
                    int t = basePos[0] - var17[0];
                    int n = t * t;
                    t = basePos[2] - var17[2];
                    double var20 = Math.sqrt(n + t * t);
                    int var22 = (int)(var20 * (double)this.branchSlope);
                    int[] var19 = new int[]{basePos[0], Math.min(var17[1] - var22, var5), basePos[2]};
                    if (this.checkBlockLine(var19, var17) != -1) continue;
                    var2[var4][0] = var15;
                    var2[var4][1] = var3;
                    var2[var4][2] = var16;
                    var2[var4][3] = var19[1];
                    ++var4;
                }
            }
            --var3;
            --var6;
        }
        this.leafNodes = var2;
        this.leafNodesLength = var4;
    }

    private void genLeafLayer(int x, int y, int z, int size) {
        int X = x;
        int Z = z;
        float maxDistSq = size * size;
        for (int xMod = -size; xMod <= size; ++xMod) {
            float distSq;
            x = X + xMod;
            int t = xMod >> 31;
            int xDistSq = xMod * xMod + ((t ^ xMod) - t);
            for (int zMod = 0; zMod <= size && !((distSq = (float)(xDistSq + zMod * zMod + zMod) + 0.5f) > maxDistSq); ++zMod) {
                for (t = -1; t <= 1; t += 2) {
                    z = Z + zMod * t;
                    Block block = this.worldObj.func_147439_a(x, y, z);
                    if (!(this.safeGrowth ? WorldGenMinableCluster.canGenerateInBlock(this.worldObj, x, y, z, this.genBlock) && (!this.treeChecks || block.isAir((IBlockAccess)this.worldObj, x, y, z) || block.isLeaves((IBlockAccess)this.worldObj, x, y, z) || block.canBeReplacedByLeaves((IBlockAccess)this.worldObj, x, y, z)) : block.func_149712_f(this.worldObj, x, y, z) >= 0.0f)) continue;
                    WeightedRandomBlock b = WorldGenMinableCluster.selectBlock(this.worldObj, this.leaves);
                    this.func_150516_a(this.worldObj, x, y, z, b.block, b.metadata);
                }
            }
        }
    }

    private void generateLeaves() {
        int[][] leafNodes = this.leafNodes;
        int e = this.leafNodesLength;
        for (int i = 0; i < e; ++i) {
            int y;
            int[] n = leafNodes[i];
            int x = n[0];
            int yO = n[1];
            int z = n[2];
            int var5 = y + this.leafDistanceLimit;
            for (y = 0; y < var5; ++y) {
                int size = y != 0 & y != this.leafDistanceLimit - 1 ? 3 : 2;
                this.genLeafLayer(x, yO++, z, size);
            }
        }
    }

    private void placeBlockLine(int[] par1, int[] par2, List<WeightedRandomBlock> block, int meta) {
        int t;
        int[] var4 = this.placeScratch;
        int var6 = 0;
        for (int i = 0; i < 3; i = (int)((byte)(i + 1))) {
            int a = par2[i] - par1[i];
            t = a >> 31;
            int b = (t ^ a) - t;
            var4[i] = a;
            a = var4[var6];
            t = a >> 31;
            if (b <= (a ^ t) - t) continue;
            var6 = i;
        }
        if (var4[var6] != 0) {
            byte var7 = otherCoordPairs[var6];
            byte var8 = otherCoordPairs[var6 + 3];
            int var9 = var4[var6] > 0 ? 1 : -1;
            float var10 = (float)var4[var7] / (float)var4[var6];
            float var12 = (float)var4[var8] / (float)var4[var6];
            int var16 = var4[var6] + var9;
            int[] var14 = var4;
            for (int var15 = 0; var15 != var16; var15 += var9) {
                var14[var6] = MathHelper.func_76141_d((float)((float)(par1[var6] + var15) + 0.5f));
                var14[var7] = MathHelper.func_76141_d((float)((float)par1[var7] + (float)var15 * var10 + 0.5f));
                var14[var8] = MathHelper.func_76141_d((float)((float)par1[var8] + (float)var15 * var12 + 0.5f));
                int var18 = var14[0] - par1[0];
                t = var18 >> 31;
                var18 = (t ^ var18) - t;
                int var19 = var14[2] - par1[2];
                t = var19 >> 31;
                var19 = (t ^ var19) - t;
                int var20 = Math.max(var18, var19);
                int var17 = meta;
                if (this.smoothLogs & var20 > 0) {
                    if (var18 == var20) {
                        var17 |= 4;
                    } else if (var19 == var20) {
                        var17 |= 8;
                    }
                }
                WeightedRandomBlock par3 = WorldGenMinableCluster.selectBlock(this.worldObj, this.trunk);
                this.func_150516_a(this.worldObj, var14[0], var14[1], var14[2], par3.block, par3.metadata | var17);
            }
        }
    }

    private void generateTrunk() {
        int var1 = this.basePos[0];
        int var2 = this.basePos[1];
        int var3 = this.basePos[1] + this.height;
        int var4 = this.basePos[2];
        int[] var5 = new int[]{var1, var2, var4};
        int[] var6 = new int[]{var1, var3, var4};
        double lim = 400.0f / (float)this.trunkSize;
        for (int i = -this.trunkSize; i <= this.trunkSize; ++i) {
            var5[0] = var1 + i;
            var6[0] = var1 + i;
            for (int j = -this.trunkSize; j <= this.trunkSize; ++j) {
                if ((j * j + i * i) * 4 >= this.trunkSize * this.trunkSize * 5) continue;
                var5[2] = var4 + j;
                var6[2] = var4 + j;
                if (this.slopeTrunk) {
                    var6[1] = var2 + WorldGenMassiveTree.sinc2(lim * (double)i, lim * (double)j, this.height) - (this.rand.nextInt(3) - 1);
                }
                this.placeBlockLine(var5, var6, this.trunk, 0);
                if (this.smoothLogs) {
                    this.func_150516_a(this.worldObj, var6[0], var6[1], var6[2], null, 12);
                }
                this.worldObj.func_147439_a(var5[0], var5[1] - 1, var5[2]).onPlantGrow(this.worldObj, var5[0], var5[1] - 1, var5[2], var1, var2, var4);
            }
        }
    }

    private static final int sinc2(double x, double z, int y) {
        double pi = Math.PI;
        double pi2 = 2.0943951023931953;
        double r = x / Math.PI;
        double d = r * r;
        r = z / Math.PI;
        if ((r = Math.sqrt(d + r * r) * Math.PI / 180.0) == 0.0) {
            return y;
        }
        return (int)Math.round((double)y * ((Math.sin(r) / r + Math.sin(r * 2.0943951023931953) / (r * 2.0943951023931953)) / 2.0));
    }

    void generateLeafNodeBases() {
        int[] start = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        int[][] leafNodes = this.leafNodes;
        int heightLimit = (int)((float)this.heightLimit * 0.2f);
        int meta = this.smoothLogs ? 12 : 0;
        int e = this.leafNodesLength;
        for (int i = 0; i < e; ++i) {
            int[] end = leafNodes[i];
            start[1] = end[3];
            int height = start[1] - this.basePos[1];
            if (height < heightLimit) continue;
            this.placeBlockLine(start, end, this.trunk, meta);
        }
    }

    private int checkBlockLine(int[] par1, int[] par2) {
        int n;
        int var14;
        int t;
        int[] var3 = this.checkScratch;
        int var5 = 0;
        for (int i = 0; i < 3; i = (int)((byte)(i + 1))) {
            int a = par2[i] - par1[i];
            t = a >> 31;
            int b = (t ^ a) - t;
            var3[i] = a;
            a = var3[var5];
            t = a >> 31;
            if (b <= (a ^ t) - t) continue;
            var5 = i;
        }
        if (var3[var5] == 0) {
            return -1;
        }
        byte var6 = otherCoordPairs[var5];
        byte var7 = otherCoordPairs[var5 + 3];
        int var8 = var3[var5] > 0 ? 1 : -1;
        float var9 = (float)var3[var6] / (float)var3[var5];
        float var11 = (float)var3[var7] / (float)var3[var5];
        int var15 = var3[var5] + var8;
        int[] var13 = var3;
        for (var14 = 0; var14 != var15; var14 += var8) {
            var13[var5] = par1[var5] + var14;
            var13[var6] = MathHelper.func_76141_d((float)((float)par1[var6] + (float)var14 * var9));
            var13[var7] = MathHelper.func_76141_d((float)((float)par1[var7] + (float)var14 * var11));
            int x = var13[0];
            int y = var13[1];
            int z = var13[2];
            Block var16 = this.worldObj.func_147439_a(x, y, z);
            if (this.safeGrowth ? WorldGenMinableCluster.canGenerateInBlock(this.worldObj, x, y, z, this.genBlock) && (!this.treeChecks || !var16.isAir((IBlockAccess)this.worldObj, x, y, z) && !var16.isReplaceable((IBlockAccess)this.worldObj, x, y, z) && !var16.canBeReplacedByLeaves((IBlockAccess)this.worldObj, x, y, z) && !var16.isLeaves((IBlockAccess)this.worldObj, x, y, z) && !var16.isWood((IBlockAccess)this.worldObj, x, y, z) && !(var16 instanceof BlockSapling)) : var16.func_149712_f(this.worldObj, x, y, z) >= 0.0f) break;
        }
        if (var14 == var15) {
            n = -1;
        } else {
            t = var14 >> 31;
            n = (t ^ var14) - t;
        }
        return n;
    }

    private boolean validTreeLocation() {
        int newHeight = Math.min(this.heightLimit + this.basePos[1], 255) - this.basePos[1];
        if (newHeight < this.minHeight) {
            return false;
        }
        this.heightLimit = newHeight;
        if (!WorldGenMinableCluster.canGenerateInBlock(this.worldObj, this.basePos[0], this.basePos[1] - 1, this.basePos[2], this.genSurface)) {
            return false;
        }
        int[] var5 = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        int[] var6 = new int[]{this.basePos[0], this.basePos[1] + this.heightLimit - 1, this.basePos[2]};
        newHeight = this.checkBlockLine(var5, var6);
        if (newHeight == -1) {
            newHeight = this.heightLimit;
        }
        if (newHeight < this.minHeight) {
            return false;
        }
        this.heightLimit = Math.min(newHeight, this.heightLimitLimit);
        this.height = (int)((float)this.heightLimit * this.heightAttenuation);
        if (this.height >= this.heightLimit) {
            this.height = this.heightLimit - 1;
        }
        this.height += this.rand.nextInt(this.heightLimit - this.height);
        if (this.safeGrowth) {
            int var1 = this.basePos[0];
            int var2 = this.basePos[1];
            int var3 = this.basePos[1] + this.height;
            int var4 = this.basePos[2];
            var5 = new int[]{var1, var2, var4};
            var6 = new int[]{var1, var3, var4};
            double lim = 400.0f / (float)this.trunkSize;
            for (int i = -this.trunkSize; i <= this.trunkSize; ++i) {
                var5[0] = var1 + i;
                var6[0] = var1 + i;
                for (int j = -this.trunkSize; j <= this.trunkSize; ++j) {
                    int t;
                    if ((j * j + i * i) * 4 >= this.trunkSize * this.trunkSize * 5) continue;
                    var5[2] = var4 + j;
                    var6[2] = var4 + j;
                    if (this.slopeTrunk) {
                        var6[1] = var2 + WorldGenMassiveTree.sinc2(lim * (double)i, lim * (double)j, this.height);
                    }
                    if ((t = this.checkBlockLine(var5, var6)) == -1) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void func_76487_a(double par1, double par3, double par5) {
        this.setTreeScale((float)par1, (float)par3, (float)par5);
    }

    public WorldGenMassiveTree setTreeScale(float height, float width, float leaves) {
        this.heightLimitLimit = (int)((double)height * 12.0);
        this.minHeight = this.heightLimitLimit / 2;
        this.trunkSize = (int)Math.round((double)height / 2.0);
        this.leafDistanceLimit = this.minHeight > 30 ? 5 : this.minHeight / 8;
        this.scaleWidth = width;
        this.branchDensity = leaves;
        return this;
    }

    public WorldGenMassiveTree setMinTrunkSize(int radius) {
        this.trunkSize = Math.max(radius, this.trunkSize);
        return this;
    }

    public WorldGenMassiveTree setLeafAttenuation(float a) {
        this.heightAttenuation = a;
        return this;
    }

    public WorldGenMassiveTree setSloped(boolean s) {
        this.slopeTrunk = s;
        return this;
    }

    public WorldGenMassiveTree setSafe(boolean s) {
        this.safeGrowth = s;
        return this;
    }

    public synchronized boolean func_76484_a(World world, Random par2Random, int x, int y, int z) {
        this.worldObj = world;
        long var6 = par2Random.nextLong();
        this.rand.setSeed(var6);
        this.basePos[0] = x;
        this.basePos[1] = y;
        this.basePos[2] = z;
        if (this.heightLimit == 0) {
            this.heightLimit = this.heightLimitLimit;
        }
        if (this.minHeight < 0) {
            this.minHeight = 80;
        }
        if (!this.validTreeLocation()) {
            this.worldObj = null;
            return false;
        }
        this.generated = false;
        this.setup();
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateLeafNodeBases();
        this.generateTrunk();
        if (this.fastPlacement) {
            TLongObjectIterator iter = this.chunkMap.iterator();
            while (iter.hasNext()) {
                PlayerManager.PlayerInstance watcher;
                PlayerManager manager;
                iter.advance();
                Chunk chunk = (Chunk)iter.value();
                chunk.func_76603_b();
                ExtendedBlockStorage[] storage = chunk.func_76587_i();
                if (!this.relightBlocks) {
                    int i = storage.length;
                    while (i-- > 0) {
                        if (storage[i] == null) continue;
                        NibbleArray a = storage[i].func_76671_l();
                        a.func_76581_a(0, 0, 0, 0);
                        a.func_76581_a(0, 0, 0, 15);
                        Arrays.fill(a.field_76585_a, (byte)0);
                    }
                    chunk.func_76613_n();
                }
                chunk.field_76643_l = true;
                if (!(world instanceof WorldServer) || (manager = ((WorldServer)world).func_73040_p()) == null || (watcher = manager.func_72690_a(chunk.field_76635_g, chunk.field_76647_h, false)) == null) continue;
                watcher.func_151251_a((Packet)new S21PacketChunkData(chunk, false, -1));
            }
        }
        this.worldObj = null;
        return this.generated;
    }

    public void func_150516_a(World world, int x, int y, int z, Block block, int meta) {
        if (y < 0 | y > 255) {
            return;
        }
        this.generated = true;
        if (!this.fastPlacement) {
            if (block != null) {
                super.func_150516_a(world, x, y, z, block, meta);
            } else {
                world.func_72921_c(x, y, z, world.func_72805_g(x, y, z) | meta, 2);
            }
            return;
        }
        long pos = (long)(x & 0xFFFFFFF0) << 32 | (long)(z & 0xFFFFFFF0);
        Chunk chunk = world.func_72938_d(x, z);
        this.chunkMap.put(pos, (Object)chunk);
        ExtendedBlockStorage[] storage = chunk.func_76587_i();
        ExtendedBlockStorage subChunk = storage[y >> 4];
        if (subChunk == null) {
            storage[y >> 4] = subChunk = new ExtendedBlockStorage(y & 0xFFFFFFF0, !world.field_73011_w.field_76576_e);
        }
        if (block != null && subChunk.func_150819_a(x &= 0xF, y & 0xF, z &= 0xF).hasTileEntity(subChunk.func_76665_b(x, y & 0xF, z))) {
            chunk.func_150805_f(x, y, z);
        }
        y &= 0xF;
        if (block != null) {
            subChunk.func_150818_a(x, y, z, block);
            subChunk.func_76654_b(x, y, z, meta);
        } else {
            subChunk.func_76654_b(x, y, z, subChunk.func_76665_b(x, y, z) | meta);
        }
        subChunk.func_76677_d(x, y, z, 0);
    }
}

