/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world;

import cofh.lib.util.WeightedRandomBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenMinableCluster
extends WorldGenerator {
    private final List<WeightedRandomBlock> cluster;
    private final int genClusterSize;
    private final WeightedRandomBlock[] genBlock;

    public static final List<WeightedRandomBlock> fabricateList(WeightedRandomBlock resource) {
        ArrayList<WeightedRandomBlock> list = new ArrayList<WeightedRandomBlock>();
        list.add(resource);
        return list;
    }

    public static final List<WeightedRandomBlock> fabricateList(Block resource) {
        ArrayList<WeightedRandomBlock> list = new ArrayList<WeightedRandomBlock>();
        list.add(new WeightedRandomBlock(new ItemStack(resource, 1, 0)));
        return list;
    }

    public WorldGenMinableCluster(ItemStack ore, int clusterSize) {
        this(new WeightedRandomBlock(ore), clusterSize);
    }

    public WorldGenMinableCluster(WeightedRandomBlock resource, int clusterSize) {
        this(WorldGenMinableCluster.fabricateList(resource), clusterSize);
    }

    public WorldGenMinableCluster(List<WeightedRandomBlock> resource, int clusterSize) {
        this(resource, clusterSize, Blocks.field_150348_b);
    }

    public WorldGenMinableCluster(ItemStack ore, int clusterSize, Block block) {
        this(new WeightedRandomBlock(ore, 1), clusterSize, block);
    }

    public WorldGenMinableCluster(WeightedRandomBlock resource, int clusterSize, Block block) {
        this(WorldGenMinableCluster.fabricateList(resource), clusterSize, block);
    }

    public WorldGenMinableCluster(List<WeightedRandomBlock> resource, int clusterSize, Block block) {
        this(resource, clusterSize, WorldGenMinableCluster.fabricateList(block));
    }

    public WorldGenMinableCluster(List<WeightedRandomBlock> resource, int clusterSize, List<WeightedRandomBlock> block) {
        this.cluster = resource;
        this.genClusterSize = clusterSize > 32 ? 32 : clusterSize;
        this.genBlock = block.toArray(new WeightedRandomBlock[block.size()]);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int blocks = this.genClusterSize;
        if (blocks < 4) {
            return this.generateTiny(world, rand, x, y, z);
        }
        float f = rand.nextFloat() * (float)Math.PI;
        float xMin = (float)(x + 8) + MathHelper.func_76126_a((float)f) * (float)blocks / 8.0f;
        float xMax = (float)(x + 8) - MathHelper.func_76126_a((float)f) * (float)blocks / 8.0f;
        float zMin = (float)(z + 8) + MathHelper.func_76134_b((float)f) * (float)blocks / 8.0f;
        float zMax = (float)(z + 8) - MathHelper.func_76134_b((float)f) * (float)blocks / 8.0f;
        float yMin = y + rand.nextInt(3) - 2;
        float yMax = y + rand.nextInt(3) - 2;
        xMax -= xMin;
        yMax -= yMin;
        zMax -= zMin;
        boolean r = false;
        for (int i = 0; i <= blocks; ++i) {
            float xCenter = xMin + xMax * (float)i / (float)blocks;
            float yCenter = yMin + yMax * (float)i / (float)blocks;
            float zCenter = zMin + zMax * (float)i / (float)blocks;
            float size = (float)rand.nextDouble() * (float)blocks / 16.0f;
            float hMod = ((MathHelper.func_76126_a((float)((float)i * (float)Math.PI / (float)blocks)) + 1.0f) * size + 1.0f) * 0.5f;
            float vMod = ((MathHelper.func_76126_a((float)((float)i * (float)Math.PI / (float)blocks)) + 1.0f) * size + 1.0f) * 0.5f;
            int xStart = MathHelper.func_76141_d((float)(xCenter - hMod));
            int yStart = MathHelper.func_76141_d((float)(yCenter - vMod));
            int zStart = MathHelper.func_76141_d((float)(zCenter - hMod));
            int xStop = MathHelper.func_76141_d((float)(xCenter + hMod));
            int yStop = MathHelper.func_76141_d((float)(yCenter + vMod));
            int zStop = MathHelper.func_76141_d((float)(zCenter + hMod));
            for (int blockX = xStart; blockX <= xStop; ++blockX) {
                float xDistSq = ((float)blockX + 0.5f - xCenter) / hMod;
                if ((xDistSq *= xDistSq) >= 1.0f) continue;
                for (int blockY = yStart; blockY <= yStop; ++blockY) {
                    float xyDistSq;
                    float yDistSq = ((float)blockY + 0.5f - yCenter) / vMod;
                    if ((xyDistSq = (yDistSq *= yDistSq) + xDistSq) >= 1.0f) continue;
                    for (int blockZ = zStart; blockZ <= zStop; ++blockZ) {
                        float zDistSq = ((float)blockZ + 0.5f - zCenter) / hMod;
                        if ((zDistSq *= zDistSq) + xyDistSq >= 1.0f) continue;
                        r |= WorldGenMinableCluster.generateBlock(world, blockX, blockY, blockZ, this.genBlock, this.cluster);
                    }
                }
            }
        }
        return r;
    }

    public boolean generateTiny(World world, Random random, int x, int y, int z) {
        boolean r = false;
        for (int i = 0; i < this.genClusterSize; ++i) {
            int d0 = x + random.nextInt(2);
            int d1 = y + random.nextInt(2);
            int d2 = z + random.nextInt(2);
            r |= WorldGenMinableCluster.generateBlock(world, d0, d1, d2, this.genBlock, this.cluster);
        }
        return r;
    }

    public static boolean canGenerateInBlock(World world, int x, int y, int z, WeightedRandomBlock[] mat) {
        if (mat == null || mat.length == 0) {
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        for (WeightedRandomBlock genBlock : mat) {
            if (-1 != genBlock.metadata && genBlock.metadata != world.func_72805_g(x, y, z) || !block.isReplaceableOreGen(world, x, y, z, genBlock.block) && !block.func_149667_c(genBlock.block)) continue;
            return true;
        }
        return false;
    }

    public static boolean generateBlock(World world, int x, int y, int z, WeightedRandomBlock[] mat, List<WeightedRandomBlock> o) {
        if (mat == null || mat.length == 0) {
            return WorldGenMinableCluster.generateBlock(world, x, y, z, o);
        }
        if (WorldGenMinableCluster.canGenerateInBlock(world, x, y, z, mat)) {
            return WorldGenMinableCluster.generateBlock(world, x, y, z, o);
        }
        return false;
    }

    public static boolean generateBlock(World world, int x, int y, int z, List<WeightedRandomBlock> o) {
        WeightedRandomBlock ore = WorldGenMinableCluster.selectBlock(world, o);
        if (ore == null) {
            return false;
        }
        return world.func_147465_d(x, y, z, ore.block, ore.metadata, 2);
    }

    public static WeightedRandomBlock selectBlock(World world, List<WeightedRandomBlock> o) {
        int size = o.size();
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            return (WeightedRandomBlock)WeightedRandom.func_76271_a((Random)world.field_73012_v, o);
        }
        return o.get(0);
    }
}

