/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.multiblock;

import io.endertech.multiblock.IMultiblockPart;
import io.endertech.multiblock.MultiblockRegistry;
import io.endertech.multiblock.MultiblockTileEntityBase;
import io.endertech.multiblock.MultiblockValidationException;
import io.endertech.network.ITilePacketHandler;
import io.endertech.network.PacketBase;
import io.endertech.network.PacketETBase;
import io.endertech.network.PacketHandler;
import io.endertech.util.BlockCoord;
import io.endertech.util.IOutlineDrawer;
import io.endertech.util.helper.LocalisationHelper;
import io.endertech.util.helper.LogHelper;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;

public abstract class MultiblockControllerBase
implements IOutlineDrawer,
ITilePacketHandler {
    public static final short DIMENSION_UNBOUNDED = -1;
    protected World worldObj;
    protected AssemblyState assemblyState;
    protected HashSet<IMultiblockPart> connectedParts;
    protected boolean debugMode;
    private BlockCoord referenceCoord;
    private BlockCoord minimumCoord;
    private BlockCoord maximumCoord;
    private boolean shouldCheckForDisconnections;
    private MultiblockValidationException lastValidationException;

    protected MultiblockControllerBase(World world) {
        this.worldObj = world;
        this.connectedParts = new HashSet();
        this.referenceCoord = null;
        this.assemblyState = AssemblyState.Disassembled;
        this.minimumCoord = null;
        this.maximumCoord = null;
        this.shouldCheckForDisconnections = true;
        this.lastValidationException = null;
        this.debugMode = false;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean active) {
        this.debugMode = active;
    }

    public abstract void onAttachedPartWithMultiblockNBT(IMultiblockPart var1, NBTTagCompound var2);

    public abstract void onAttachedPartWithMultiblockPacket(IMultiblockPart var1, PacketETBase var2);

    public boolean hasBlock(BlockCoord blockCoord) {
        return this.connectedParts.contains(blockCoord);
    }

    public void attachBlock(IMultiblockPart part) {
        BlockCoord coord = part.getWorldLocation();
        if (!this.connectedParts.add(part)) {
            LogHelper.warn(LocalisationHelper.localiseString("warning.multiblock.part.double_adding", this.worldObj.field_72995_K ? "CLIENT" : "SERVER", this.hashCode(), part.hashCode(), coord), new Object[0]);
        }
        part.onAttached(this);
        this.onBlockAdded(part);
        if (part.hasMultiblockNBTCache()) {
            this.onAttachedPartWithMultiblockNBT(part, part.getMultiblockNBTCache());
            part.onMultiblockDataAssimilated();
        } else if (part.hasMultiblockMessageCache()) {
            this.onAttachedPartWithMultiblockPacket(part, part.getMultiblockPacketCache());
            part.onMultiblockDataAssimilated();
        }
        if (this.referenceCoord == null) {
            this.referenceCoord = coord;
            part.becomeMultiblockSaveDelegate();
        } else if (coord.compareTo(this.referenceCoord) < 0) {
            TileEntity te = this.worldObj.func_147438_o(this.referenceCoord.x, this.referenceCoord.y, this.referenceCoord.z);
            ((IMultiblockPart)te).forfeitMultiblockSaveDelegate();
            this.referenceCoord = coord;
            part.becomeMultiblockSaveDelegate();
        } else {
            part.forfeitMultiblockSaveDelegate();
        }
        if (this.minimumCoord != null) {
            if (part.field_145851_c < this.minimumCoord.x) {
                this.minimumCoord.x = part.field_145851_c;
            }
            if (part.field_145848_d < this.minimumCoord.y) {
                this.minimumCoord.y = part.field_145848_d;
            }
            if (part.field_145849_e < this.minimumCoord.z) {
                this.minimumCoord.z = part.field_145849_e;
            }
        }
        if (this.maximumCoord != null) {
            if (part.field_145851_c > this.maximumCoord.x) {
                this.maximumCoord.x = part.field_145851_c;
            }
            if (part.field_145848_d > this.maximumCoord.y) {
                this.maximumCoord.y = part.field_145848_d;
            }
            if (part.field_145849_e > this.maximumCoord.z) {
                this.maximumCoord.z = part.field_145849_e;
            }
        }
        MultiblockRegistry.addDirtyController(this.worldObj, this);
    }

    protected abstract void onBlockAdded(IMultiblockPart var1);

    protected abstract void onBlockRemoved(IMultiblockPart var1);

    protected abstract void onMachineAssembled();

    protected abstract void onMachineRestored();

    protected abstract void onMachinePaused();

    protected abstract void onMachineDisassembled();

    private void onDetachBlock(IMultiblockPart part) {
        part.onDetached(this);
        this.onBlockRemoved(part);
        part.forfeitMultiblockSaveDelegate();
        this.maximumCoord = null;
        this.minimumCoord = null;
        if (this.referenceCoord != null && this.referenceCoord.equals(part.field_145851_c, part.field_145848_d, part.field_145849_e)) {
            this.referenceCoord = null;
        }
        this.shouldCheckForDisconnections = true;
    }

    public void detachBlock(IMultiblockPart part, boolean chunkUnloading) {
        if (chunkUnloading && this.assemblyState == AssemblyState.Assembled) {
            this.assemblyState = AssemblyState.Paused;
            this.onMachinePaused();
        }
        this.onDetachBlock(part);
        if (!this.connectedParts.remove(part)) {
            LogHelper.warn(LocalisationHelper.localiseString("warning.multiblock.part.double_removing", this.worldObj.field_72995_K ? "CLIENT" : "SERVER", part.hashCode(), part.field_145851_c, part.field_145848_d, part.field_145849_e), new Object[0]);
        }
        if (this.connectedParts.isEmpty()) {
            MultiblockRegistry.addDeadController(this.worldObj, this);
            return;
        }
        MultiblockRegistry.addDirtyController(this.worldObj, this);
        if (this.referenceCoord == null) {
            this.selectNewReferenceCoord();
        }
    }

    protected abstract int getMinimumNumberOfBlocksForAssembledMachine();

    protected abstract int getMaximumXSize();

    protected abstract int getMaximumZSize();

    protected abstract int getMaximumYSize();

    protected int getMinimumXSize() {
        return 1;
    }

    protected int getMinimumYSize() {
        return 1;
    }

    protected int getMinimumZSize() {
        return 1;
    }

    public MultiblockValidationException getLastValidationException() {
        return this.lastValidationException;
    }

    protected abstract void isMachineWhole() throws MultiblockValidationException;

    public void checkIfMachineIsWhole() {
        boolean isWhole;
        AssemblyState oldState = this.assemblyState;
        this.lastValidationException = null;
        try {
            this.isMachineWhole();
            isWhole = true;
        }
        catch (MultiblockValidationException e) {
            this.lastValidationException = e;
            isWhole = false;
        }
        if (isWhole) {
            this.assembleMachine(oldState);
        } else if (oldState == AssemblyState.Assembled) {
            this.disassembleMachine();
        }
    }

    private void assembleMachine(AssemblyState oldState) {
        this.assemblyState = AssemblyState.Assembled;
        for (IMultiblockPart part : this.connectedParts) {
            part.onMachineAssembled(this);
        }
        if (oldState == AssemblyState.Paused) {
            this.onMachineRestored();
        } else {
            this.onMachineAssembled();
        }
    }

    private void disassembleMachine() {
        this.assemblyState = AssemblyState.Disassembled;
        for (IMultiblockPart part : this.connectedParts) {
            part.onMachineBroken();
        }
        this.onMachineDisassembled();
    }

    public void assimilate(MultiblockControllerBase other) {
        BlockCoord otherReferenceCoord = other.getReferenceCoord();
        if (otherReferenceCoord != null && this.getReferenceCoord().compareTo(otherReferenceCoord) >= 0) {
            throw new IllegalArgumentException("The controller with the lowest minimum-coord value must consume the one with the higher coords");
        }
        HashSet<IMultiblockPart> partsToAcquire = new HashSet<IMultiblockPart>(other.connectedParts);
        other._onAssimilated(this);
        for (IMultiblockPart acquiredPart : partsToAcquire) {
            if (acquiredPart.func_145837_r()) continue;
            this.connectedParts.add(acquiredPart);
            acquiredPart.onAssimilated(this);
            this.onBlockAdded(acquiredPart);
        }
        this.onAssimilate(other);
        other.onAssimilated(this);
    }

    private void _onAssimilated(MultiblockControllerBase otherController) {
        if (this.referenceCoord != null) {
            TileEntity te;
            if (this.worldObj.func_72863_F().func_73149_a(this.referenceCoord.getChunkX(), this.referenceCoord.getChunkZ()) && (te = this.worldObj.func_147438_o(this.referenceCoord.x, this.referenceCoord.y, this.referenceCoord.z)) instanceof IMultiblockPart) {
                ((IMultiblockPart)te).forfeitMultiblockSaveDelegate();
            }
            this.referenceCoord = null;
        }
        this.connectedParts.clear();
    }

    protected abstract void onAssimilate(MultiblockControllerBase var1);

    protected abstract void onAssimilated(MultiblockControllerBase var1);

    public final void updateMultiblockEntity() {
        if (this.connectedParts.isEmpty()) {
            MultiblockRegistry.addDeadController(this.worldObj, this);
            return;
        }
        if (this.assemblyState != AssemblyState.Assembled) {
            return;
        }
        if (this.worldObj.field_72995_K) {
            this.updateClient();
        } else if (this.updateServer()) {
            if (this.minimumCoord != null && this.maximumCoord != null && this.worldObj.func_72904_c(this.minimumCoord.x, this.minimumCoord.y, this.minimumCoord.z, this.maximumCoord.x, this.maximumCoord.y, this.maximumCoord.z)) {
                int minChunkX = this.minimumCoord.x >> 4;
                int minChunkZ = this.minimumCoord.z >> 4;
                int maxChunkX = this.maximumCoord.x >> 4;
                int maxChunkZ = this.maximumCoord.z >> 4;
                for (int x = minChunkX; x <= maxChunkX; ++x) {
                    for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                        Chunk chunkToSave = this.worldObj.func_72964_e(x, z);
                        chunkToSave.func_76630_e();
                    }
                }
            }
            this.sendUpdatePacketToClosePlayers();
        }
    }

    public void sendUpdatePacketToClosePlayers() {
        BlockCoord referenceCoord = this.getReferenceCoord();
        TileEntity tileEntity = this.worldObj.func_147438_o(referenceCoord.x, referenceCoord.y, referenceCoord.z);
        if (tileEntity != null && tileEntity instanceof MultiblockTileEntityBase) {
            PacketHandler.sendToAllAround((PacketBase)((MultiblockTileEntityBase)tileEntity).getPacket(), tileEntity);
        }
    }

    protected abstract boolean updateServer();

    protected abstract void updateClient();

    protected void isBlockGoodForFrame(World world, int x, int y, int z) throws MultiblockValidationException {
        throw new MultiblockValidationException(LocalisationHelper.localiseString("info.multiblock.part.unsuitable.frame", x, y, z));
    }

    protected void isBlockGoodForTop(World world, int x, int y, int z) throws MultiblockValidationException {
        throw new MultiblockValidationException(LocalisationHelper.localiseString("info.multiblock.part.unsuitable.top", x, y, z));
    }

    protected void isBlockGoodForBottom(World world, int x, int y, int z) throws MultiblockValidationException {
        throw new MultiblockValidationException(LocalisationHelper.localiseString("info.multiblock.part.unsuitable.bottom", x, y, z));
    }

    protected void isBlockGoodForSides(World world, int x, int y, int z) throws MultiblockValidationException {
        throw new MultiblockValidationException(LocalisationHelper.localiseString("info.multiblock.part.unsuitable.sides", x, y, z));
    }

    protected void isBlockGoodForInterior(World world, int x, int y, int z) throws MultiblockValidationException {
        throw new MultiblockValidationException(LocalisationHelper.localiseString("info.multiblock.part.unsuitable.interior", x, y, z));
    }

    public BlockCoord getReferenceCoord() {
        if (this.referenceCoord == null) {
            this.selectNewReferenceCoord();
        }
        return this.referenceCoord;
    }

    public Set<IMultiblockPart> getConnectedParts() {
        return this.connectedParts;
    }

    public int getNumConnectedBlocks() {
        return this.connectedParts.size();
    }

    public abstract void writeToNBT(NBTTagCompound var1);

    public abstract void readFromNBT(NBTTagCompound var1);

    public void recalculateMinMaxCoords() {
        this.minimumCoord = new BlockCoord(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.maximumCoord = new BlockCoord(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        for (IMultiblockPart part : this.connectedParts) {
            if (part.field_145851_c < this.minimumCoord.x) {
                this.minimumCoord.x = part.field_145851_c;
            }
            if (part.field_145851_c > this.maximumCoord.x) {
                this.maximumCoord.x = part.field_145851_c;
            }
            if (part.field_145848_d < this.minimumCoord.y) {
                this.minimumCoord.y = part.field_145848_d;
            }
            if (part.field_145848_d > this.maximumCoord.y) {
                this.maximumCoord.y = part.field_145848_d;
            }
            if (part.field_145849_e < this.minimumCoord.z) {
                this.minimumCoord.z = part.field_145849_e;
            }
            if (part.field_145849_e <= this.maximumCoord.z) continue;
            this.maximumCoord.z = part.field_145849_e;
        }
    }

    public BlockCoord getMinimumCoord() {
        if (this.minimumCoord == null) {
            this.recalculateMinMaxCoords();
        }
        return this.minimumCoord.copy();
    }

    public BlockCoord getMaximumCoord() {
        if (this.maximumCoord == null) {
            this.recalculateMinMaxCoords();
        }
        return this.maximumCoord.copy();
    }

    public abstract PacketETBase getPacket(PacketETBase var1);

    public boolean isEmpty() {
        return this.connectedParts.isEmpty();
    }

    public boolean shouldConsume(MultiblockControllerBase otherController) {
        if (!otherController.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException(LocalisationHelper.localiseString("error.multiblock.consuming.different_classes", new Object[0]));
        }
        if (otherController == this) {
            return false;
        }
        int res = this._shouldConsume(otherController);
        if (res < 0) {
            return true;
        }
        if (res > 0) {
            return false;
        }
        LogHelper.warn(LocalisationHelper.localiseString("warning.multiblock.consuming.same_reference_coordinate", this.worldObj.field_72995_K ? "CLIENT" : "SERVER"), new Object[0]);
        this.auditParts();
        otherController.auditParts();
        res = this._shouldConsume(otherController);
        if (res < 0) {
            return true;
        }
        if (res > 0) {
            return false;
        }
        LogHelper.fatal(LocalisationHelper.localiseString("error.multiblock.consuming.my_controller", this.hashCode(), this.connectedParts.size(), this.getPartsListString()), new Object[0]);
        LogHelper.fatal(LocalisationHelper.localiseString("error.multiblock.consuming.other_controller", otherController.hashCode(), otherController.connectedParts.size(), otherController.getPartsListString()), new Object[0]);
        throw new IllegalArgumentException(LocalisationHelper.localiseString("error.multiblock.consuming.same_reference_coordinate", this.worldObj.field_72995_K ? "CLIENT" : "SERVER"));
    }

    private int _shouldConsume(MultiblockControllerBase otherController) {
        BlockCoord myCoord = this.getReferenceCoord();
        BlockCoord theirCoord = otherController.getReferenceCoord();
        if (theirCoord == null) {
            return -1;
        }
        return myCoord.compareTo(theirCoord);
    }

    private String getPartsListString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (IMultiblockPart part : this.connectedParts) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(String.format("(%d: %d, %d, %d)", part.hashCode(), part.field_145851_c, part.field_145848_d, part.field_145849_e));
            first = false;
        }
        return sb.toString();
    }

    private void auditParts() {
        HashSet<IMultiblockPart> deadParts = new HashSet<IMultiblockPart>();
        for (IMultiblockPart part : this.connectedParts) {
            if (!part.func_145837_r() && this.worldObj.func_147438_o(part.field_145851_c, part.field_145848_d, part.field_145849_e) == part) continue;
            this.onDetachBlock(part);
            deadParts.add(part);
        }
        this.connectedParts.removeAll(deadParts);
        LogHelper.warn(LocalisationHelper.localiseString("warning.multiblock.audit", this.worldObj.field_72995_K ? "CLIENT" : "SERVER", deadParts.size(), this.connectedParts.size()), new Object[0]);
    }

    public Set<IMultiblockPart> checkForDisconnections() {
        if (!this.shouldCheckForDisconnections) {
            return null;
        }
        if (this.isEmpty()) {
            MultiblockRegistry.addDeadController(this.worldObj, this);
            return null;
        }
        IChunkProvider chunkProvider = this.worldObj.func_72863_F();
        this.referenceCoord = null;
        HashSet<IMultiblockPart> deadParts = new HashSet<IMultiblockPart>();
        IMultiblockPart referencePart = null;
        int originalSize = this.connectedParts.size();
        for (IMultiblockPart part : this.connectedParts) {
            if (!chunkProvider.func_73149_a(part.field_145851_c >> 4, part.field_145849_e >> 4) || part.func_145837_r()) {
                deadParts.add(part);
                this.onDetachBlock(part);
                continue;
            }
            if (this.worldObj.func_147438_o(part.field_145851_c, part.field_145848_d, part.field_145849_e) != part) {
                deadParts.add(part);
                this.onDetachBlock(part);
                continue;
            }
            part.setUnvisited();
            part.forfeitMultiblockSaveDelegate();
            BlockCoord c = part.getWorldLocation();
            if (this.referenceCoord == null) {
                this.referenceCoord = c;
                referencePart = part;
                continue;
            }
            if (c.compareTo(this.referenceCoord) >= 0) continue;
            this.referenceCoord = c;
            referencePart = part;
        }
        this.connectedParts.removeAll(deadParts);
        deadParts.clear();
        if (referencePart == null || this.isEmpty()) {
            this.shouldCheckForDisconnections = false;
            MultiblockRegistry.addDeadController(this.worldObj, this);
            return null;
        }
        referencePart.becomeMultiblockSaveDelegate();
        LinkedList<IMultiblockPart> partsToCheck = new LinkedList<IMultiblockPart>();
        IMultiblockPart[] nearbyParts = null;
        int visitedParts = 0;
        partsToCheck.add(referencePart);
        while (!partsToCheck.isEmpty()) {
            IMultiblockPart part = (IMultiblockPart)partsToCheck.removeFirst();
            part.setVisited();
            ++visitedParts;
            for (IMultiblockPart nearbyPart : nearbyParts = part.getNeighboringParts()) {
                if (nearbyPart.getMultiblockController() != this || nearbyPart.isVisited()) continue;
                nearbyPart.setVisited();
                partsToCheck.add(nearbyPart);
            }
        }
        HashSet<IMultiblockPart> removedParts = new HashSet<IMultiblockPart>();
        for (IMultiblockPart orphanCandidate : this.connectedParts) {
            if (orphanCandidate.isVisited()) continue;
            deadParts.add(orphanCandidate);
            orphanCandidate.onOrphaned(this, originalSize, visitedParts);
            this.onDetachBlock(orphanCandidate);
            removedParts.add(orphanCandidate);
        }
        this.connectedParts.removeAll(deadParts);
        deadParts.clear();
        if (this.referenceCoord == null) {
            this.selectNewReferenceCoord();
        }
        this.shouldCheckForDisconnections = false;
        return removedParts;
    }

    public Set<IMultiblockPart> detachAllBlocks() {
        if (this.worldObj == null) {
            return new HashSet<IMultiblockPart>();
        }
        IChunkProvider chunkProvider = this.worldObj.func_72863_F();
        for (IMultiblockPart part : this.connectedParts) {
            if (!chunkProvider.func_73149_a(part.field_145851_c >> 4, part.field_145849_e >> 4)) continue;
            this.onDetachBlock(part);
        }
        HashSet<IMultiblockPart> detachedParts = this.connectedParts;
        this.connectedParts = new HashSet();
        return detachedParts;
    }

    public boolean isAssembled() {
        return this.assemblyState == AssemblyState.Assembled;
    }

    private void selectNewReferenceCoord() {
        IChunkProvider chunkProvider = this.worldObj.func_72863_F();
        IMultiblockPart theChosenOne = null;
        this.referenceCoord = null;
        for (IMultiblockPart part : this.connectedParts) {
            if (part.func_145837_r() || !chunkProvider.func_73149_a(part.field_145851_c >> 4, part.field_145849_e >> 4) || this.referenceCoord != null && this.referenceCoord.compareTo(part.field_145851_c, part.field_145848_d, part.field_145849_e) <= 0) continue;
            this.referenceCoord = part.getWorldLocation();
            theChosenOne = part;
        }
        if (theChosenOne != null) {
            ((IMultiblockPart)theChosenOne).becomeMultiblockSaveDelegate();
        }
    }

    public abstract String getName();

    public abstract List<String> getWailaBody();

    @Override
    public boolean drawOutline(DrawBlockHighlightEvent event) {
        return false;
    }

    protected static enum AssemblyState {
        Disassembled,
        Assembled,
        Paused;

    }
}

