/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.utils;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.headcrumbs.Headcrumbs;
import ganymedes01.headcrumbs.network.PacketHandler;
import ganymedes01.headcrumbs.network.packet.TextureRequestPacket;
import ganymedes01.headcrumbs.utils.helpers.EtFuturumHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class TextureUtils {
    private static final ResourceLocation LARGE_STEVE_TEXTURE = new ResourceLocation("etfuturum", "textures/entity/steve.png");
    public static final Map<MinecraftProfileTexture.Type, Map<String, ResourceLocation>> textures = new HashMap<MinecraftProfileTexture.Type, Map<String, ResourceLocation>>();

    public static ResourceLocation getPlayerSkin(GameProfile profile) {
        return TextureUtils.getPlayerImage(profile, MinecraftProfileTexture.Type.SKIN);
    }

    public static ResourceLocation getPlayerCape(GameProfile profile) {
        return TextureUtils.getPlayerImage(profile, MinecraftProfileTexture.Type.CAPE);
    }

    private static ResourceLocation getPlayerImage(GameProfile profile, MinecraftProfileTexture.Type type) {
        if (profile != null && profile.getName() != null) {
            Minecraft mc = Minecraft.func_71410_x();
            if (profile.getName().equals(mc.field_71439_g.func_146103_bH().getName())) {
                ResourceLocation texture;
                ResourceLocation resourceLocation = texture = type == MinecraftProfileTexture.Type.CAPE ? mc.field_71439_g.func_110303_q() : mc.field_71439_g.func_110306_p();
                if (texture != null && Headcrumbs.use18PlayerModel) {
                    texture = new ResourceLocation("etfuturum", texture.func_110623_a());
                }
                return texture;
            }
            Map<String, ResourceLocation> mappedTextures = textures.get(type);
            if (mappedTextures.containsKey(profile.getName())) {
                return mappedTextures.get(profile.getName());
            }
            mappedTextures.put(profile.getName(), TextureUtils.getDefault(type));
            if (type == MinecraftProfileTexture.Type.SKIN) {
                PacketHandler.sendToServer(new TextureRequestPacket(profile.getName()));
            }
        }
        return TextureUtils.getDefault(type);
    }

    public static ResourceLocation getDefault(MinecraftProfileTexture.Type type) {
        return type == MinecraftProfileTexture.Type.CAPE ? null : (Headcrumbs.use18PlayerModel ? LARGE_STEVE_TEXTURE : AbstractClientPlayer.field_110314_b);
    }

    public static boolean isAlexModel(ResourceLocation texture) {
        return Headcrumbs.use18PlayerModel && EtFuturumHelper.isAlexModel(texture);
    }

    static {
        textures.put(MinecraftProfileTexture.Type.CAPE, new HashMap());
        textures.put(MinecraftProfileTexture.Type.SKIN, new HashMap());
    }
}

