/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.version;

import aroma1997.core.Reference;
import aroma1997.core.log.AromaSpecialLogger;
import aroma1997.core.log.LogHelperPre;
import aroma1997.core.version.ThreadVersionChecking;
import aroma1997.core.version.VersionInfo;
import aroma1997.core.version.VersionStates;
import aroma1997.core.web.xml.XMLParser;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import org.apache.logging.log4j.Level;
import org.w3c.dom.Node;

public class VersionCheck {
    private static boolean hasLoogedError = false;
    private static HashSet<VersionInfo> mods = new HashSet();

    public static VersionStates checkUpdates(String url, String compareVersion, String compareModID) {
        block4: {
            try {
                XMLParser xml = new XMLParser(new URL(url).openStream());
                for (Map.Entry<String, Node> entry : xml.getAll().entrySet()) {
                    if (entry.getKey().split("\\.").length != 2) continue;
                    String mod = entry.getKey().split("\\.")[0];
                    String mcversion = entry.getKey().split("\\.")[1];
                    if (!mod.equalsIgnoreCase(compareModID) || !mcversion.equalsIgnoreCase("MC" + Reference.MCVERSION.replace(".", ""))) continue;
                    if (entry.getValue().getTextContent().equalsIgnoreCase(compareVersion)) {
                        return VersionStates.LATEST;
                    }
                    return VersionStates.OUTDATED;
                }
            }
            catch (Exception e) {
                if (hasLoogedError) break block4;
                LogHelperPre.log(Level.ERROR, "Failed to do VersionChecking. Check your network connection.");
                hasLoogedError = true;
            }
        }
        return VersionStates.FAILED;
    }

    public static void registerVersionChecker(String compareModID, String compareVersion) {
        if (compareVersion.toLowerCase().contains("b") || compareVersion.toLowerCase().contains("$")) {
            LogHelperPre.log(Level.INFO, "Using a beta-version of the mod: " + compareModID + " not registering VersionChecker.");
            return;
        }
        mods.add(new VersionInfo(compareModID, compareVersion));
    }

    public static void registerVersionChecker(String compareModID, String compareVersion, String xmlFile, String updateURL) {
        if (compareVersion.toLowerCase().contains("b") || compareVersion.toLowerCase().contains("$")) {
            LogHelperPre.log(Level.INFO, "Using a beta-version of the mod: " + compareModID + " not registering VersionChecker.");
            return;
        }
        mods.add(new VersionInfo(compareModID, compareVersion, updateURL, xmlFile));
    }

    static HashSet<String> getUpdateMessages() {
        HashSet<String> messages = new HashSet<String>();
        int i = 0;
        for (Object info : mods.toArray()) {
            if (!(info instanceof VersionInfo)) {
                LogHelperPre.logException("Failed to do VersionChecking.", new RuntimeException("Failed to do versionChecking"));
                return null;
            }
            VersionInfo versInfo = (VersionInfo)info;
            VersionStates state = VersionCheck.checkUpdates(versInfo.getXMLURL(), versInfo.getVersion(), versInfo.getModID());
            if (state == VersionStates.OUTDATED) {
                messages.add("The mod " + versInfo.getModID() + " is outdated. Please update it from " + versInfo.updateURL());
                continue;
            }
            if (state != VersionStates.FAILED) continue;
            ++i;
        }
        if (i == mods.size() && mods.size() != 0) {
            messages.add("Aroma1997Core failed to do VersionChecking. Either there is something wrong with your network connection or with my server.");
        }
        return messages;
    }

    public static void doVersionCheck(ICommandSender sender) {
        new ThreadVersionChecking(sender);
    }

    public static void doVersionCheck() {
        new ThreadVersionChecking(AromaSpecialLogger.instance);
    }
}

