/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.debug;

import java.util.Collection;
import java.util.HashMap;
import net.minecraft.command.ICommandSender;

public abstract class DebugHierarchy {
    public static final DebugNode root = new DebugNode();

    public static interface DebugTaskCallback
    extends IDebugElement {
        public void run(ICommandSender var1, Object ... var2);
    }

    public static interface DebugValueCallback
    extends IDebugElement {
        public String get(ICommandSender var1);

        public void set(ICommandSender var1, String var2);
    }

    public static class DebugNode
    implements IDebugElement {
        public final DebugNode parent;
        private HashMap<String, IDebugElement> children = new HashMap();
        private HashMap<IDebugElement, String> keymap = new HashMap();

        private DebugNode() {
            this.parent = null;
        }

        private DebugNode(DebugNode parent) {
            this.parent = parent;
        }

        public void addChild(String id, IDebugElement elem) {
            if (elem instanceof DebugNode) {
                throw new RuntimeException("Cannot register nodes as children. Use DebugNode.createNode instead.");
            }
            if (id.contains(".")) {
                throw new RuntimeException("Cannot register elements with '.' in id.");
            }
            String key = id.replaceAll(" ", "_");
            if (this.children.containsKey(key)) {
                this.keymap.remove(this.children.remove(key));
            }
            this.keymap.put(elem, key);
            this.children.put(key, elem);
        }

        public DebugNode getOrCreateNode(String id) {
            if (id.contains(".")) {
                throw new RuntimeException("Cannot register elements with '.' in id.");
            }
            String key = id.replaceAll(" ", "_");
            if (this.children.containsKey(key)) {
                IDebugElement node = this.children.get(key);
                if (node instanceof DebugNode) {
                    return (DebugNode)node;
                }
                throw new RuntimeException("Address already registered to non-node element.");
            }
            DebugNode elem = new DebugNode(this);
            this.keymap.put(elem, key);
            this.children.put(key, elem);
            return elem;
        }

        public void removeChild(IDebugElement elem) {
            String key = this.keymap.remove(elem);
            if (key != null) {
                this.children.remove(key);
            }
        }

        public void removeChild(String key) {
            IDebugElement elem = this.children.remove(key);
            if (elem != null) {
                this.keymap.remove(elem);
            }
        }

        public Collection<String> getChildren() {
            return this.children.keySet();
        }

        public IDebugElement get(String key) {
            return this.children.get(key);
        }
    }

    public static interface IDebugElement {
    }
}

