/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.entity;

import com.xcompwiz.mystcraft.nbt.NBTUtils;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ReportedException;
import net.minecraft.world.World;

public class EntityFallingBlock
extends Entity
implements IEntityAdditionalSpawnData {
    private static final String NBT_Drops = "Drops";
    private static final String NBT_TE = "TE";
    public Block block;
    public int metadata;
    public int fallTime = 0;
    private NBTTagCompound data;
    private ArrayList collidingBoundingBoxes = new ArrayList();

    public EntityFallingBlock(World world) {
        super(world);
    }

    private EntityFallingBlock(World world, double d, double d1, double d2, Block block, int j, NBTTagCompound data) {
        super(world);
        this.block = block;
        this.metadata = j;
        this.field_70156_m = true;
        this.func_70105_a(0.98f, 0.98f);
        this.field_70129_M = this.field_70131_O / 2.0f;
        this.func_70107_b(d, d1, d2);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
        this.data = data;
    }

    public static void cascade(World world, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) == Blocks.field_150362_t) {
            EntityFallingBlock.drop(world, i, j, k);
        }
    }

    public static void drop(World world, int i, int j, int k) {
        if (world.field_72995_K) {
            return;
        }
        boolean flag = false;
        Material material = world.func_147439_a(i, j, k).func_149688_o();
        if (material == Material.field_151587_i || material == Material.field_151586_h) {
            flag = true;
            world.func_147465_d(i, j, k, Blocks.field_150350_a, 0, 2);
            material = world.func_147439_a(i, ++j, k).func_149688_o();
            return;
        }
        if (flag) {
            return;
        }
        if (world.func_147437_c(i, j, k)) {
            return;
        }
        if (!world.func_147437_c(i, j - 1, k)) {
            return;
        }
        NBTTagCompound data = new NBTTagCompound();
        ArrayList drops = world.func_147439_a(i, j, k).getDrops(world, i, j, k, world.func_72805_g(i, j, k), 0);
        data.func_74782_a(NBT_Drops, (NBTBase)NBTUtils.writeItemStackCollection(new NBTTagList(), drops));
        if (world.func_147438_o(i, j, k) != null) {
            NBTTagCompound tedata = new NBTTagCompound();
            world.func_147438_o(i, j, k).func_145841_b(tedata);
            world.func_147475_p(i, j, k);
            data.func_74782_a(NBT_TE, (NBTBase)tedata);
        }
        EntityFallingBlock entityfalling = new EntityFallingBlock(world, (float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, world.func_147439_a(i, j, k), world.func_72805_g(i, j, k), data);
        world.func_147465_d(i, j, k, Blocks.field_150350_a, 0, 2);
        world.func_72838_d((Entity)entityfalling);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70026_G() {
        return this.func_70090_H();
    }

    protected void func_70088_a() {
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70071_h_() {
        if (this.block == null) {
            this.func_70106_y();
            return;
        }
        ++this.fallTime;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70181_x -= (double)0.04f;
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= (double)0.98f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)0.98f;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70163_u);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        if (this.field_70122_E) {
            if (this.field_70170_p.field_72995_K) {
                return;
            }
            this.func_70106_y();
            this.place(x, y, z);
            return;
        }
        if (this.field_70163_u < -10.0 && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            return;
        }
        if (this.fallTime == 1 && !this.field_70170_p.field_72995_K) {
            EntityFallingBlock.cascade(this.field_70170_p, x - 1, y, z);
            EntityFallingBlock.cascade(this.field_70170_p, x + 1, y, z);
            EntityFallingBlock.cascade(this.field_70170_p, x, y, z - 1);
            EntityFallingBlock.cascade(this.field_70170_p, x, y, z + 1);
            EntityFallingBlock.drop(this.field_70170_p, x, y + 1, z);
            EntityFallingBlock.drop(this.field_70170_p, x + 1, y + 1, z);
            EntityFallingBlock.drop(this.field_70170_p, x - 1, y + 1, z);
            EntityFallingBlock.drop(this.field_70170_p, x, y + 1, z + 1);
            EntityFallingBlock.drop(this.field_70170_p, x, y + 1, z - 1);
        }
    }

    private void place(int x, int y, int z) {
        if (!this.field_70170_p.func_147465_d(x, y, z, this.block, this.metadata, 2)) {
            this.handleDrops();
        } else {
            this.field_70170_p.func_72921_c(x, y, z, this.metadata, 2);
            if (this.data != null && this.data.func_74764_b(NBT_TE)) {
                NBTTagCompound tileentity = this.data.func_74775_l(NBT_TE);
                tileentity.func_74768_a("x", x);
                tileentity.func_74768_a("y", y);
                tileentity.func_74768_a("z", z);
                if (this.field_70170_p.func_147438_o(x, y, z) != null) {
                    this.field_70170_p.func_147438_o(x, y, z).func_145839_a(tileentity);
                } else {
                    this.field_70170_p.func_147455_a(x, y, z, TileEntity.func_145827_c((NBTTagCompound)tileentity));
                }
            }
        }
    }

    public void func_70091_d(double dx, double dy, double dz) {
        if (this.field_70145_X) {
            this.field_70121_D.func_72317_d(dx, dy, dz);
            this.field_70165_t = (this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d) / 2.0;
            this.field_70163_u = this.field_70121_D.field_72338_b + (double)this.field_70129_M - (double)this.field_70139_V;
            this.field_70161_v = (this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f) / 2.0;
        } else {
            int j;
            this.field_70170_p.field_72984_F.func_76320_a("move");
            this.field_70139_V *= 0.4f;
            if (this.field_70134_J) {
                this.field_70134_J = false;
                dx *= 0.25;
                dy *= (double)0.05f;
                dz *= 0.25;
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            double dx0 = dx;
            double dy0 = dy;
            double dz0 = dz;
            this.collidingBoundingBoxes = this.getCollidingBoundingBoxes(this.field_70121_D.func_72321_a(dx, dy, dz), this.collidingBoundingBoxes);
            for (int i = 0; i < this.collidingBoundingBoxes.size(); ++i) {
                dy = ((AxisAlignedBB)this.collidingBoundingBoxes.get(i)).func_72323_b(this.field_70121_D, dy);
            }
            this.field_70121_D.func_72317_d(0.0, dy, 0.0);
            if (!this.field_70135_K && dy0 != dy) {
                dz = 0.0;
                dy = 0.0;
                dx = 0.0;
            }
            for (j = 0; j < this.collidingBoundingBoxes.size(); ++j) {
                dx = ((AxisAlignedBB)this.collidingBoundingBoxes.get(j)).func_72316_a(this.field_70121_D, dx);
            }
            this.field_70121_D.func_72317_d(dx, 0.0, 0.0);
            if (!this.field_70135_K && dx0 != dx) {
                dz = 0.0;
                dy = 0.0;
                dx = 0.0;
            }
            for (j = 0; j < this.collidingBoundingBoxes.size(); ++j) {
                dz = ((AxisAlignedBB)this.collidingBoundingBoxes.get(j)).func_72322_c(this.field_70121_D, dz);
            }
            this.field_70121_D.func_72317_d(0.0, 0.0, dz);
            if (!this.field_70135_K && dz0 != dz) {
                dz = 0.0;
                dy = 0.0;
                dx = 0.0;
            }
            this.field_70170_p.field_72984_F.func_76319_b();
            this.field_70170_p.field_72984_F.func_76320_a("rest");
            this.field_70165_t = (this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d) / 2.0;
            this.field_70163_u = this.field_70121_D.field_72338_b + (double)this.field_70129_M - (double)this.field_70139_V;
            this.field_70161_v = (this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f) / 2.0;
            this.field_70123_F = dx0 != dx || dz0 != dz;
            this.field_70124_G = dy0 != dy;
            this.field_70122_E = dy0 != dy && dy0 < 0.0;
            this.field_70132_H = this.field_70123_F || this.field_70124_G;
            this.func_70064_a(dy, this.field_70122_E);
            if (dx0 != dx) {
                this.field_70159_w = 0.0;
            }
            if (dy0 != dy) {
                this.field_70181_x = 0.0;
            }
            if (dz0 != dz) {
                this.field_70179_y = 0.0;
            }
            try {
                this.func_145775_I();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Checking entity block collision");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being checked for collision");
                this.func_85029_a(crashreportcategory);
                throw new ReportedException(crashreport);
            }
            this.field_70170_p.field_72984_F.func_76319_b();
        }
    }

    public ArrayList getCollidingBoundingBoxes(AxisAlignedBB bounding, ArrayList collidingBoundingBoxes) {
        collidingBoundingBoxes.clear();
        int i = MathHelper.func_76128_c((double)bounding.field_72340_a);
        int j = MathHelper.func_76128_c((double)(bounding.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)bounding.field_72338_b);
        int l = MathHelper.func_76128_c((double)(bounding.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)bounding.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(bounding.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = i1; l1 < j1; ++l1) {
                if (!this.field_70170_p.func_72899_e(k1, 64, l1)) continue;
                for (int i2 = k - 1; i2 < l; ++i2) {
                    Block block = k1 >= -30000000 && k1 < 30000000 && l1 >= -30000000 && l1 < 30000000 ? this.field_70170_p.func_147439_a(k1, i2, l1) : Blocks.field_150348_b;
                    block.func_149743_a(this.field_70170_p, k1, i2, l1, bounding, (List)collidingBoundingBoxes, (Entity)this);
                }
            }
        }
        return collidingBoundingBoxes;
    }

    private void handleDrops() {
        NBTTagList drops = this.data.func_150295_c(NBT_Drops, 10);
        ArrayList<ItemStack> items = NBTUtils.readItemStackCollection(drops, new ArrayList());
        for (ItemStack itemstack : items) {
            this.func_70099_a(itemstack, 0.0f);
        }
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("TileID", Block.func_149682_b((Block)this.block));
        nbttagcompound.func_74777_a("Metadata", (short)this.metadata);
        nbttagcompound.func_74777_a("fallTime", (short)this.fallTime);
        if (this.data != null) {
            nbttagcompound.func_74782_a("Data", (NBTBase)this.data);
        }
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        this.block = nbttagcompound.func_74764_b("TileID") ? Block.func_149729_e((int)nbttagcompound.func_74762_e("TileID")) : Block.func_149729_e((int)nbttagcompound.func_74762_e("Tile"));
        this.metadata = nbttagcompound.func_74765_d("Metadata");
        this.fallTime = nbttagcompound.func_74765_d("fallTime");
        if (nbttagcompound.func_74764_b("Data")) {
            this.data = nbttagcompound.func_74775_l("Data");
        }
        if (nbttagcompound.func_74764_b("TileEntity")) {
            NBTTagCompound tileentity = nbttagcompound.func_74775_l("TileEntity");
            this.data = new NBTTagCompound();
            this.data.func_74782_a(NBT_TE, (NBTBase)tileentity);
        }
    }

    public float func_70053_R() {
        return 0.0f;
    }

    public World getWorld() {
        return this.field_70170_p;
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(Block.func_149682_b((Block)this.block));
        data.writeByte(this.metadata);
    }

    public void readSpawnData(ByteBuf data) {
        this.block = Block.func_149729_e((int)data.readInt());
        this.metadata = data.readByte();
    }
}

