/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.util.ColorGradient;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.api.world.logic.ICelestial;
import com.xcompwiz.mystcraft.data.Assets;
import com.xcompwiz.mystcraft.symbol.SunsetRenderer;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class SymbolSunNormal
extends SymbolBase {
    public SymbolSunNormal(String identifier) {
        super(identifier);
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        Number period = controller.popModifier("wavelength").asNumber();
        Number angle = controller.popModifier("angle").asNumber();
        Number offset = controller.popModifier("phase").asNumber();
        ColorGradient sunset = controller.popModifier("sunset").asGradient();
        controller.registerInterface(new CelestialObject(controller, seed, period, angle, offset, sunset));
    }

    private static class CelestialObject
    extends SunsetRenderer
    implements ICelestial {
        private Random rand;
        private long period;
        private float angle;
        private float offset;

        CelestialObject(AgeDirector controller, long seed, Number period, Number angle, Number offset, ColorGradient gradient) {
            super(controller, gradient);
            this.rand = new Random(seed);
            if (period == null) {
                period = 0.4 * this.rand.nextDouble() + 0.8;
            }
            this.period = (long)(period.doubleValue() * 24000.0);
            if (angle == null) {
                angle = this.rand.nextDouble() * 360.0;
            }
            this.angle = -angle.floatValue();
            if (offset != null) {
                offset = Float.valueOf(offset.floatValue() / 360.0f);
            }
            if (offset == null) {
                offset = Float.valueOf(this.rand.nextFloat());
                if (this.period == 0L) {
                    offset = Float.valueOf(offset.floatValue() / 2.0f + 0.25f);
                }
            }
            this.offset = offset.floatValue() - 0.5f;
        }

        @Override
        public boolean providesLight() {
            return true;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void render(TextureManager eng, World worldObj, float partial) {
            Tessellator tessellator = Tessellator.field_78398_a;
            float invertRain = 1.0f - worldObj.func_72867_j(partial);
            float celestial_period = this.getAltitudeAngle(worldObj.func_72820_D(), partial);
            GL11.glEnable((int)3553);
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)invertRain);
            GL11.glPushMatrix();
            GL11.glRotatef((float)this.angle, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(celestial_period * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            float size = 30.0f;
            eng.func_110577_a(Assets.Vanilla.normal_sun);
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)(-size), 100.0, (double)(-size), 0.0, 0.0);
            tessellator.func_78374_a((double)size, 100.0, (double)(-size), 1.0, 0.0);
            tessellator.func_78374_a((double)size, 100.0, (double)size, 1.0, 1.0);
            tessellator.func_78374_a((double)(-size), 100.0, (double)size, 0.0, 1.0);
            tessellator.func_78381_a();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
            this.renderHorizon(eng, worldObj, celestial_period, this.angle, partial, 1.0f);
        }

        @Override
        public float getAltitudeAngle(long time, float partialTime) {
            if (this.period == 0L) {
                return this.offset;
            }
            int i = (int)(time % this.period);
            float f = ((float)i + partialTime) / (float)this.period + this.offset;
            if (f < 0.0f) {
                f += 1.0f;
            }
            if (f > 1.0f) {
                f -= 1.0f;
            }
            float f1 = f;
            f = 1.0f - (float)((Math.cos((double)f * Math.PI) + 1.0) / 2.0);
            f = f1 + (f - f1) / 3.0f;
            return f;
        }

        @Override
        public Long getTimeToDawn(long time) {
            if (this.period == 0L) {
                return null;
            }
            long current = time % this.period;
            long next = (long)((float)this.period * Math.abs(0.75f - this.offset));
            if (current > next) {
                next += this.period;
            }
            return next - current;
        }
    }
}

