/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.utility;

import com.xcompwiz.mystcraft.logging.LoggerUtils;
import java.util.Collection;
import java.util.Random;

public class WeightedItemSelector {
    public static <T> float getTotalWeight(Collection<T> collection) {
        return WeightedItemSelector.getTotalWeight(collection, WeightProviderDefault.instance);
    }

    public static <T> float getTotalWeight(Collection<T> collection, IWeightProvider wgtprov) {
        float total = 0.0f;
        for (T item : collection) {
            total += wgtprov.getItemWeight(item);
        }
        return total;
    }

    public static <T> T getRandomItem(Random rand, Collection<T> collection) {
        return WeightedItemSelector.getRandomItem(rand, collection, WeightProviderDefault.instance);
    }

    public static <T> T getRandomItem(Random rand, Collection<T> collection, IWeightProvider wgtprov) {
        if (collection == null) {
            return null;
        }
        float max = WeightedItemSelector.getTotalWeight(collection, wgtprov);
        if (max <= 0.0f) {
            return WeightedItemSelector.getRandomItemEvenly(rand, collection);
        }
        T last = null;
        float selection = rand.nextFloat() * max;
        for (T item : collection) {
            float weight = wgtprov.getItemWeight(item);
            selection -= weight;
            if (!(weight > 0.0f)) continue;
            if (selection <= 0.0f) {
                return item;
            }
            last = item;
        }
        LoggerUtils.warn("Something odd happened when selecting a random item from a weighted collection.", new Object[0]);
        return last;
    }

    public static <T> T getRandomItemEvenly(Random rand, Collection<T> collection) {
        T last = null;
        float selection = rand.nextFloat() * (float)collection.size();
        for (T item : collection) {
            if ((selection -= 1.0f) <= 0.0f) {
                return item;
            }
            last = item;
        }
        LoggerUtils.warn("Something odd happened when selecting a random item from an evenly weighted collection.", new Object[0]);
        return last;
    }

    public static class WeightProviderDefault
    implements IWeightProvider {
        public static WeightProviderDefault instance = new WeightProviderDefault();

        private WeightProviderDefault() {
        }

        @Override
        public float getItemWeight(Object item) {
            if (item instanceof IWeightedItem) {
                return ((IWeightedItem)item).getWeight();
            }
            return 1.0f;
        }
    }

    public static interface IWeightedItem {
        public float getWeight();
    }

    public static interface IWeightProvider {
        public float getItemWeight(Object var1);
    }
}

