/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.profiling;

import com.xcompwiz.mystcraft.debug.DebugHierarchy;
import com.xcompwiz.mystcraft.symbol.modifiers.SymbolBiome;
import com.xcompwiz.mystcraft.world.AgeController;
import com.xcompwiz.mystcraft.world.WorldProviderMyst;
import com.xcompwiz.mystcraft.world.agedata.AgeData;
import com.xcompwiz.mystcraft.world.profiling.ChunkProfiler;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.ChunkProviderServer;

public class WorldProviderMystDummy
extends WorldProviderMyst {
    private AgeController controller;
    private static ChunkProfiler chunkprofiler;
    private static int chunkX_min;
    private static int chunkZ_min;
    private static int chunkZ_max;
    private int chunkX;
    private int chunkZ;
    private boolean chunkproviderreplaced;

    public static void setChunkProfiler(ChunkProfiler profiler) {
        chunkprofiler = profiler;
    }

    public static void setBounds(int chunkX_min, int chunkX_max, int chunkZ_min, int chunkZ_max) {
        WorldProviderMystDummy.chunkX_min = chunkX_min;
        WorldProviderMystDummy.chunkZ_min = chunkZ_min;
        WorldProviderMystDummy.chunkZ_max = chunkZ_max;
    }

    private static boolean outOfBounds(int chunkX, int chunkZ) {
        return chunkZ < chunkZ_min || chunkZ > chunkZ_max || chunkX < chunkX_min;
    }

    @Override
    protected void func_76572_b() {
        this.chunkX = chunkX_min;
        this.chunkZ = chunkZ_min;
        this.agedata = new AgeData("CONTROL");
        this.agedata.setAgeName("CONTROL");
        this.agedata.setSpawn(null);
        this.agedata.setInstabilityEnabled(true);
        for (BiomeGenBase biome : SymbolBiome.selectables) {
            this.agedata.addSymbol("Biome" + biome.field_76756_M, 0);
        }
        this.agedata.addSymbol("BioConGrid", 0);
        this.agedata.addSymbol("ModMat_tile.stone", 0);
        this.agedata.addSymbol("ModMat_tile.water", 0);
        this.agedata.addSymbol("TerrainNormal", 0);
        this.agedata.addSymbol("ModMat_tile.water", 0);
        this.agedata.addSymbol("LakesSurface", 0);
        this.agedata.addSymbol("ModMat_tile.lava", 0);
        this.agedata.addSymbol("LakesDeep", 0);
        this.agedata.addSymbol("Caves", 0);
        this.agedata.addSymbol("Ravines", 0);
        this.agedata.addSymbol("Villages", 0);
        this.agedata.addSymbol("Mineshafts", 0);
        this.agedata.addSymbol("WeatherNorm", 0);
        this.agedata.addSymbol("LightingNormal", 0);
        this.agedata.markVisited();
        this.controller = new AgeControllerDummy(this.field_76579_a, this.agedata);
        this.field_76578_c = this.controller.getWorldChunkManager();
        this.setWorldInfo();
    }

    @Override
    public AgeController getAgeController() {
        return this.controller;
    }

    @Override
    public String func_80007_l() {
        return "CONTROL";
    }

    @Override
    public void updateWeather() {
        this.getAgeController().tick();
        this.getAgeController().getWeatherController().updateRaining();
    }

    @Override
    public BiomeGenBase getBiomeGenForCoords(int x, int z) {
        return this.field_76578_c.func_76935_a(x, z);
    }

    @Override
    public boolean func_76566_a(int x, int z) {
        return true;
    }

    @Override
    public boolean func_76567_e() {
        return false;
    }

    @Override
    public void calculateInitialWeather() {
        super.calculateInitialWeather();
        this.replaceChunkProvider();
    }

    public void replaceChunkProvider() {
        if (this.chunkproviderreplaced) {
            return;
        }
        this.chunkproviderreplaced = true;
        WorldServer world = (WorldServer)this.field_76579_a;
        world.field_73059_b = new ChunkProviderServerDummy(world, (IChunkLoader)new AnvilChunkLoaderDummy(((AnvilChunkLoader)world.field_73059_b.field_73247_e).field_75825_d), this.func_76555_c());
        ObfuscationReflectionHelper.setPrivateValue(World.class, (Object)this.field_76579_a, (Object)world.field_73059_b, (String[])new String[]{"chunkProvider", "field_73020_y"});
    }

    public void generateNextChunk() {
        ChunkProviderServer chunkgen = ((WorldServer)this.field_76579_a).field_73059_b;
        IChunkLoader chunkloader = ((WorldServer)this.field_76579_a).field_73059_b.field_73247_e;
        if (this.safeLoadChunk(chunkloader, this.field_76579_a, this.chunkX, this.chunkZ) == null) {
            chunkgen.func_73158_c(this.chunkX, this.chunkZ);
        }
        ++this.chunkZ;
        if (this.chunkZ > chunkZ_max) {
            this.chunkZ = chunkZ_min;
            ++this.chunkX;
        }
    }

    private Chunk safeLoadChunk(IChunkLoader chunkloader, World worldObj, int par1, int par2) {
        if (chunkloader == null) {
            return null;
        }
        try {
            return chunkloader.func_75815_a(worldObj, par1, par2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private class AgeControllerDummy
    extends AgeController {
        public AgeControllerDummy(World worldObj, AgeData age) {
            super(worldObj, age);
        }

        @Override
        public ChunkProfiler getChunkProfiler() {
            return chunkprofiler;
        }

        @Override
        public void registerDebugInfo(DebugHierarchy.DebugNode node) {
        }
    }

    private static class ChunkProviderServerDummy
    extends ChunkProviderServer {
        private Chunk defaultEmptyChunk;
        private List<Long> chunkqueue = new LinkedList<Long>();

        public ChunkProviderServerDummy(WorldServer worldServer, IChunkLoader loader, IChunkProvider provider) {
            super(worldServer, loader, provider);
            this.defaultEmptyChunk = new EmptyChunk((World)worldServer, 0, 0);
        }

        public boolean func_73157_c() {
            return false;
        }

        public Chunk originalLoadChunk(int chunkX, int chunkZ) {
            if (WorldProviderMystDummy.outOfBounds(chunkX, chunkZ)) {
                return this.defaultEmptyChunk;
            }
            Chunk chunk = super.originalLoadChunk(chunkX, chunkZ);
            this.chunkqueue.add(ChunkCoordIntPair.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h));
            return chunk;
        }

        public boolean func_73156_b() {
            for (int i = 0; i < 100 && this.chunkqueue.size() > 64; ++i) {
                Long olong = this.chunkqueue.get(0);
                Chunk chunk = (Chunk)this.field_73244_f.func_76164_a(olong.longValue());
                if (chunk != null) {
                    chunk.func_76623_d();
                    this.field_73245_g.remove(chunk);
                }
                this.chunkqueue.remove(0);
                this.field_73244_f.func_76159_d(olong.longValue());
            }
            return this.field_73246_d.func_73156_b();
        }
    }

    private static class AnvilChunkLoaderDummy
    extends AnvilChunkLoader {
        public AnvilChunkLoaderDummy(File p_i2003_1_) {
            super(p_i2003_1_);
        }

        public boolean chunkExists(World world, int i, int j) {
            return false;
        }

        public Chunk func_75815_a(World p_75815_1_, int p_75815_2_, int p_75815_3_) throws IOException {
            return null;
        }
    }
}

