/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.api.liquid;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import minetweaker.api.liquid.ILiquidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;

@ZenClass(value="minetweaker.item.WeightedItemStack")
public final class WeightedLiquidStack {
    private final ILiquidStack stack;
    private final float p;

    public static List<ILiquidStack> pickRandomDrops(Random random, WeightedLiquidStack[] items) {
        ArrayList<ILiquidStack> result = new ArrayList<ILiquidStack>();
        for (WeightedLiquidStack item : items) {
            if (!(random.nextFloat() <= item.getChance())) continue;
            result.add(item.getStack());
        }
        return result;
    }

    public WeightedLiquidStack(ILiquidStack stack, float p) {
        this.stack = stack;
        this.p = p;
    }

    @ZenGetter(value="stack")
    public ILiquidStack getStack() {
        return this.stack;
    }

    @ZenGetter(value="chance")
    public float getChance() {
        return this.p;
    }

    @ZenGetter(value="percent")
    public float getPercent() {
        return this.p * 100.0f;
    }

    public int hashCode() {
        int hash = 17;
        hash = 29 * hash + (this.stack != null ? this.stack.hashCode() : 0);
        hash = 29 * hash + Float.floatToIntBits(this.p);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WeightedLiquidStack other = (WeightedLiquidStack)obj;
        if (!(this.stack == other.stack || this.stack != null && this.stack.equals(other.stack))) {
            return false;
        }
        return Float.floatToIntBits(this.p) == Float.floatToIntBits(other.p);
    }
}

