/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.api.IEApi;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ComparableItemStack {
    public ItemStack stack;
    public boolean useNBT;
    public boolean ignoreOreDict;
    public int oreID = -1;

    public ComparableItemStack(ItemStack stack) {
        if (stack == null) {
            throw new RuntimeException("You cannot instantiate a ComparableItemStack with null for an Item!");
        }
        this.stack = stack;
        int[] oids = OreDictionary.getOreIDs((ItemStack)stack);
        if (oids != null && oids.length > 0) {
            this.oreID = oids[0];
        }
    }

    public ComparableItemStack(String oreName) {
        this(IEApi.getPreferredOreStack(oreName));
        this.oreID = OreDictionary.getOreID((String)oreName);
    }

    public ComparableItemStack setUseNBT(boolean useNBT) {
        this.useNBT = useNBT;
        return this;
    }

    public ComparableItemStack setOreID(int oid) {
        this.oreID = oid;
        return this;
    }

    public String toString() {
        return "ComparableStack: {" + this.stack.toString() + "}; oreID: " + this.oreID + "; checkNBT: " + this.useNBT;
    }

    public int hashCode() {
        if (!this.ignoreOreDict && this.oreID != -1) {
            return this.oreID;
        }
        return (this.stack.func_77960_j() & 0xFFFF) * 31 + this.stack.func_77973_b().hashCode() * 31;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ComparableItemStack)) {
            return false;
        }
        if (this.oreID != -1 && ((ComparableItemStack)object).oreID != -1) {
            return this.oreID == ((ComparableItemStack)object).oreID;
        }
        ItemStack otherStack = ((ComparableItemStack)object).stack;
        if (!OreDictionary.itemMatches((ItemStack)this.stack, (ItemStack)otherStack, (boolean)false)) {
            return false;
        }
        return !this.useNBT || ItemStack.func_77970_a((ItemStack)this.stack, (ItemStack)otherStack);
    }
}

