/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.AdvancedAABB;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.WireType;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.api.tool.ZoomHandler;
import blusunrize.immersiveengineering.client.ClientProxy;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.fx.ParticleRenderer;
import blusunrize.immersiveengineering.client.gui.GuiBlastFurnace;
import blusunrize.immersiveengineering.client.models.ModelIEObj;
import blusunrize.immersiveengineering.client.render.TileRenderArcFurnace;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.gui.ContainerRevolver;
import blusunrize.immersiveengineering.common.items.ItemChemthrower;
import blusunrize.immersiveengineering.common.items.ItemDrill;
import blusunrize.immersiveengineering.common.items.ItemRevolver;
import blusunrize.immersiveengineering.common.items.ItemSkyhook;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Lib;
import blusunrize.immersiveengineering.common.util.SkylineHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.GregTechHelper;
import blusunrize.immersiveengineering.common.util.network.MessageRequestBlockUpdate;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelVillager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.obj.Face;
import net.minecraftforge.client.model.obj.GroupObject;
import net.minecraftforge.client.model.obj.TextureCoordinate;
import net.minecraftforge.client.model.obj.WavefrontObject;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class ClientEventHandler {
    public static IIcon iconItemBlank;
    public static int itemSheetWidth;
    public static int itemSheetHeight;
    public static Set<ImmersiveNetHandler.Connection> skyhookGrabableConnections;
    static boolean connectionsRendered;

    @SubscribeEvent
    public void textureStich(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 0) {
            if (IEContent.IECreosote) {
                IEContent.fluidCreosote.setIcons(event.map.func_94245_a("immersiveengineering:fluid/creosote_still"), event.map.func_94245_a("immersiveengineering:fluid/creosote_flow"));
            }
            if (IEContent.IEPlantoil) {
                IEContent.fluidPlantoil.setIcons(event.map.func_94245_a("immersiveengineering:fluid/plantoil_still"), event.map.func_94245_a("immersiveengineering:fluid/plantoil_flow"));
            }
            if (IEContent.IEEthanol) {
                IEContent.fluidEthanol.setIcons(event.map.func_94245_a("immersiveengineering:fluid/ethanol_still"), event.map.func_94245_a("immersiveengineering:fluid/ethanol_flow"));
            }
            if (IEContent.IEBiodiesel) {
                IEContent.fluidBiodiesel.setIcons(event.map.func_94245_a("immersiveengineering:fluid/biodiesel_still"), event.map.func_94245_a("immersiveengineering:fluid/biodiesel_flow"));
            }
            WireType.iconDefaultWire = event.map.func_94245_a("immersiveengineering:wire");
            TileRenderArcFurnace.hotMetal_flow = event.map.func_94245_a("immersiveengineering:fluid/hotMetal_flow");
            TileRenderArcFurnace.hotMetal_still = event.map.func_94245_a("immersiveengineering:fluid/hotMetal_still");
        }
        if (event.map.func_130086_a() == 1) {
            iconItemBlank = event.map.func_94245_a("immersiveengineering:white");
        }
        if (event.map.func_130086_a() == Config.getInt("revolverSheetID")) {
            IELogger.info("Stitching Revolver Textures!");
            ((ItemRevolver)IEContent.itemRevolver).stichRevolverTextures((IIconRegister)event.map);
        }
        for (ShaderRegistry.ShaderRegistryEntry entry : ShaderRegistry.shaderRegistry.values()) {
            for (ShaderCase sCase : entry.getCases()) {
                sCase.stichTextures((IIconRegister)event.map, event.map.func_130086_a());
            }
        }
    }

    @SubscribeEvent
    public void textureStich(TextureStitchEvent.Post event) {
        if (event.map.func_130086_a() == 0) {
            for (ModelIEObj modelIE : ModelIEObj.existingStaticRenders) {
                WavefrontObject model = modelIE.rebindModel();
                this.rebindUVsToIcon(model, modelIE);
            }
        }
        if (event.map.func_130086_a() == 1) {
            itemSheetWidth = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
            itemSheetHeight = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        }
    }

    void rebindUVsToIcon(WavefrontObject model, ModelIEObj modelIE) {
        for (GroupObject groupObject : model.groupObjects) {
            IIcon icon = modelIE.getBlockIcon(groupObject.name);
            if (icon == null) continue;
            float minU = icon.func_94214_a(0.0);
            float sizeU = icon.func_94214_a(16.0) - minU;
            float minV = icon.func_94207_b(0.0);
            float sizeV = icon.func_94207_b(16.0) - minV;
            float baseOffsetU = 16.0f / (float)icon.func_94211_a() * 5.0E-4f;
            float baseOffsetV = 16.0f / (float)icon.func_94216_b() * 5.0E-4f;
            for (Face face : groupObject.faces) {
                int i;
                float averageU = 0.0f;
                float averageV = 0.0f;
                if (face.textureCoordinates != null && face.textureCoordinates.length > 0) {
                    for (i = 0; i < face.textureCoordinates.length; ++i) {
                        averageU += face.textureCoordinates[i].u;
                        averageV += face.textureCoordinates[i].v;
                    }
                    averageU /= (float)face.textureCoordinates.length;
                    averageV /= (float)face.textureCoordinates.length;
                }
                for (i = 0; i < face.vertices.length; ++i) {
                    TextureCoordinate textureCoordinate = face.textureCoordinates[i];
                    float offsetU = baseOffsetU;
                    float offsetV = baseOffsetV;
                    if (face.textureCoordinates[i].u > averageU) {
                        offsetU = -offsetU;
                    }
                    if (face.textureCoordinates[i].v > averageV) {
                        offsetV = -offsetV;
                    }
                    face.textureCoordinates[i] = new TextureCoordinate(minU + sizeU * (textureCoordinate.u + offsetU), minV + sizeV * (textureCoordinate.v + offsetV));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ItemStack stack;
        EntityPlayer player;
        if (event.side.isClient() && event.phase == TickEvent.Phase.START && event.player == ClientUtils.mc().field_71451_h) {
            skyhookGrabableConnections.clear();
            player = event.player;
            stack = player.func_71045_bC();
            if (stack != null && stack.func_77973_b() instanceof ItemSkyhook) {
                TileEntity connector = null;
                double lastDist = 0.0;
                ImmersiveNetHandler.Connection line = null;
                double py = player.field_70163_u + (double)player.func_70047_e();
                for (int xx = -2; xx <= 2; ++xx) {
                    for (int zz = -2; zz <= 2; ++zz) {
                        for (int yy = 0; yy <= 3; ++yy) {
                            ImmersiveNetHandler.Connection con;
                            TileEntity tile = player.field_70170_p.func_147438_o((int)player.field_70165_t + xx, (int)py + yy, (int)player.field_70161_v + zz);
                            if (tile == null || (con = SkylineHelper.getTargetConnection(player.field_70170_p, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, (EntityLivingBase)player, null)) == null) continue;
                            double d = tile.func_145835_a(player.field_70165_t, py, player.field_70161_v);
                            if (connector != null && !(d < lastDist)) continue;
                            connector = tile;
                            lastDist = d;
                            line = con;
                        }
                    }
                }
                if (line != null && connector != null) {
                    skyhookGrabableConnections.add(line);
                }
            }
        }
        if (event.side.isClient() && event.phase == TickEvent.Phase.END && event.player != null) {
            boolean twohanded;
            player = event.player;
            stack = player.func_71045_bC();
            boolean bl = twohanded = stack != null && stack.func_77973_b() instanceof ItemDrill;
            if (twohanded && (player != ClientUtils.mc().field_71451_h || ClientUtils.mc().field_71474_y.field_74320_O != 0) && player.func_71052_bv() <= 0) {
                player.func_71041_bz();
                player.func_71008_a(stack, Integer.MAX_VALUE);
            }
            if (!Minecraft.func_71410_x().func_71387_A() && ItemDrill.animationTimer != null && ItemDrill.animationTimer.containsKey(player.func_70005_c_())) {
                ConcurrentHashMap<String, Integer> concurrentHashMap = ItemDrill.animationTimer;
                synchronized (concurrentHashMap) {
                    Integer timer;
                    Integer n = timer = ItemDrill.animationTimer.get(player.func_70005_c_());
                    Integer n2 = timer = Integer.valueOf(timer - 1);
                    if (timer < 18 && timer > 15) {
                        timer = 20;
                    }
                    if (timer > 0) {
                        ItemDrill.animationTimer.put(player.func_70005_c_(), timer);
                    } else {
                        ItemDrill.animationTimer.remove(player.func_70005_c_());
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && ClientUtils.mc().field_71462_r != null && ClientUtils.mc().field_71462_r instanceof GuiBlastFurnace && BlastFurnaceRecipe.isValidBlastFuel(event.itemStack)) {
            event.toolTip.add(EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"desc.ImmersiveEngineering.info.blastFuelTime", (Object[])new Object[]{BlastFurnaceRecipe.getBlastFuelTime(event.itemStack)}));
        }
    }

    @SubscribeEvent
    public void lastWorldRender(RenderWorldLastEvent event) {
        connectionsRendered = false;
        ParticleRenderer.dispatch();
    }

    public static void renderAllIEConnections(float partial) {
        if (connectionsRendered) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        RenderHelper.func_74519_b();
        Tessellator.field_78398_a.func_78371_b(7);
        EntityLivingBase viewer = ClientUtils.mc().field_71451_h;
        double dx = viewer.field_70142_S + (viewer.field_70165_t - viewer.field_70142_S) * (double)partial;
        double dy = viewer.field_70137_T + (viewer.field_70163_u - viewer.field_70137_T) * (double)partial;
        double dz = viewer.field_70136_U + (viewer.field_70161_v - viewer.field_70136_U) * (double)partial;
        for (Object o : ClientUtils.mc().field_71438_f.field_147598_a) {
            if (!(o instanceof IImmersiveConnectable)) continue;
            TileEntity tile = (TileEntity)o;
            Tessellator.field_78398_a.func_78373_b((double)tile.field_145851_c - dx, (double)tile.field_145848_d - dy, (double)tile.field_145849_e - dz);
            ClientUtils.renderAttachedConnections(tile);
        }
        Iterator<ImmersiveNetHandler.Connection> it = skyhookGrabableConnections.iterator();
        World world = viewer.field_70170_p;
        while (it.hasNext()) {
            ImmersiveNetHandler.Connection con = it.next();
            Tessellator.field_78398_a.func_78373_b((double)con.start.field_71574_a - dx, (double)con.start.field_71572_b - dy, (double)con.start.field_71573_c - dz);
            double r = con.cableType.getRenderDiameter() / 2.0;
            ClientUtils.drawConnection(con, Utils.toIIC(con.start, world), Utils.toIIC(con.end, world), 65433, 128, r * 1.75, con.cableType.getIcon(con));
        }
        Tessellator.field_78398_a.func_78373_b(0.0, 0.0, 0.0);
        Tessellator.field_78398_a.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        connectionsRendered = true;
    }

    @SubscribeEvent
    public void onRenderOverlayPre(RenderGameOverlayEvent.Pre event) {
        if (ZoomHandler.isZooming && event.type == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            event.setCanceled(true);
            if (ZoomHandler.isZooming) {
                ZoomHandler.IZoomTool tool;
                float[] steps;
                ClientUtils.bindTexture("immersiveengineering:textures/gui/scope.png");
                int width = event.resolution.func_78326_a();
                int height = event.resolution.func_78328_b();
                int resMin = Math.min(width, height);
                float offsetX = (float)(width - resMin) / 2.0f;
                float offsetY = (float)(height - resMin) / 2.0f;
                if (resMin == width) {
                    ClientUtils.drawColouredRect(0, 0, width, (int)offsetY + 1, -16777216);
                    ClientUtils.drawColouredRect(0, (int)offsetY + resMin, width, (int)offsetY + 1, -16777216);
                } else {
                    ClientUtils.drawColouredRect(0, 0, (int)offsetX + 1, height, -16777216);
                    ClientUtils.drawColouredRect((int)offsetX + resMin, 0, (int)offsetX + 1, height, -16777216);
                }
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GL11.glTranslatef((float)offsetX, (float)offsetY, (float)0.0f);
                ClientUtils.drawTexturedRect(0.0f, 0.0f, (float)resMin, (float)resMin, 0.0, 1.0, 0.0, 1.0);
                ClientUtils.bindTexture("immersiveengineering:textures/gui/hudElements.png");
                ClientUtils.drawTexturedRect(0.8515625f * (float)resMin, 0.25f * (float)resMin, 0.09375f * (float)resMin, 0.5f * (float)resMin, 0.25, 0.34375, 0.375, 0.875);
                ItemStack equipped = ClientUtils.mc().field_71439_g.func_71045_bC();
                if (equipped != null && equipped.func_77973_b() instanceof ZoomHandler.IZoomTool && (steps = (tool = (ZoomHandler.IZoomTool)equipped.func_77973_b()).getZoomSteps(equipped, (EntityPlayer)ClientUtils.mc().field_71439_g)) != null && steps.length > 1) {
                    int curStep = -1;
                    float dist = 0.0f;
                    float totalOffset = 0.0f;
                    float stepLength = 118.0f / (float)steps.length;
                    float stepOffset = (stepLength - 7.0f) / 2.0f;
                    GL11.glTranslatef((float)(0.87109375f * (float)resMin), (float)(0.25f * (float)resMin), (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)((5.0f + stepOffset) / 256.0f * (float)resMin), (float)0.0f);
                    for (int i = 0; i < steps.length; ++i) {
                        ClientUtils.drawTexturedRect(0.0f, 0.0f, 0.03125f * (float)resMin, 0.02734375f * (float)resMin, 0.34375, 0.375, 0.375, 0.40234375);
                        GL11.glTranslatef((float)0.0f, (float)(stepLength / 256.0f * (float)resMin), (float)0.0f);
                        totalOffset += stepLength;
                        if (curStep != -1 && !(Math.abs(steps[i] - ZoomHandler.fovZoom) < dist)) continue;
                        curStep = i;
                        dist = Math.abs(steps[i] - ZoomHandler.fovZoom);
                    }
                    GL11.glTranslatef((float)0.0f, (float)(-totalOffset / 256.0f * (float)resMin), (float)0.0f);
                    if (curStep >= 0 && curStep < steps.length) {
                        GL11.glTranslatef((float)(0.0234375f * (float)resMin), (float)((float)curStep * stepLength / 256.0f * (float)resMin), (float)0.0f);
                        ClientUtils.drawTexturedRect(0.0f, 0.0f, 0.03125f * (float)resMin, 0.02734375f * (float)resMin, 0.34375, 0.3828125, 0.40234375, 0.4296875);
                        ClientUtils.font().func_78276_b(1.0f / steps[curStep] + "x", (int)(0.0625f * (float)resMin), 0, 0xFFFFFF);
                        GL11.glTranslatef((float)(-0.0234375f * (float)resMin), (float)((float)(-curStep) * stepLength / 256.0f * (float)resMin), (float)0.0f);
                    }
                    GL11.glTranslatef((float)0.0f, (float)(-((5.0f + stepOffset) / 256.0f * (float)resMin)), (float)0.0f);
                    GL11.glTranslatef((float)(-0.87109375f * (float)resMin), (float)(-0.25f * (float)resMin), (float)0.0f);
                }
                GL11.glTranslatef((float)(-offsetX), (float)(-offsetY), (float)0.0f);
            }
        }
    }

    @SubscribeEvent
    public void onRenderOverlayPost(RenderGameOverlayEvent.Post event) {
        if (ClientUtils.mc().field_71439_g != null && event.type == RenderGameOverlayEvent.ElementType.TEXT) {
            TileEntity tileEntity;
            MovingObjectPosition mop;
            EntityClientPlayerMP player = ClientUtils.mc().field_71439_g;
            if (player.func_71045_bC() != null) {
                ItemStack equipped = player.func_71045_bC();
                if (OreDictionary.itemMatches((ItemStack)new ItemStack((Item)IEContent.itemTool, 1, 2), (ItemStack)equipped, (boolean)false) || OreDictionary.itemMatches((ItemStack)new ItemStack((Item)IEContent.itemWireCoil, 1, Short.MAX_VALUE), (ItemStack)equipped, (boolean)false)) {
                    int[] link;
                    if (ItemNBTHelper.hasKey(equipped, "linkingPos") && (link = ItemNBTHelper.getIntArray(equipped, "linkingPos")) != null && link.length > 3) {
                        String s = StatCollector.func_74837_a((String)"desc.ImmersiveEngineering.info.attachedTo", (Object[])new Object[]{link[1], link[2], link[3]});
                        ClientUtils.font().func_85187_a(s, event.resolution.func_78326_a() / 2 - ClientUtils.font().func_78256_a(s) / 2, event.resolution.func_78328_b() - GuiIngameForge.left_height - 10, WireType.ELECTRUM.getColour(null), true);
                    }
                } else if (equipped.func_77973_b() instanceof ItemRevolver && equipped.func_77960_j() != 2) {
                    ClientUtils.bindTexture("immersiveengineering:textures/gui/revolver.png");
                    ItemStack[] bullets = ((ItemRevolver)equipped.func_77973_b()).getBullets(equipped);
                    int bulletAmount = bullets.length;
                    float dx = event.resolution.func_78326_a() - 32 - 48;
                    float dy = event.resolution.func_78328_b() - 64;
                    GL11.glPushMatrix();
                    GL11.glEnable((int)3042);
                    GL11.glTranslated((double)dx, (double)dy, (double)0.0);
                    GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
                    ClientUtils.drawTexturedRect(0.0f, 1.0f, 74.0f, 74.0f, 0.0, 0.2890625, 0.19921875, 0.48828125);
                    if (bulletAmount >= 18) {
                        ClientUtils.drawTexturedRect(47.0f, 1.0f, 103.0f, 74.0f, 0.2890625, 0.69140625, 0.19921875, 0.48828125);
                    } else if (bulletAmount > 8) {
                        ClientUtils.drawTexturedRect(57.0f, 1.0f, 79.0f, 39.0f, 0.22265625, 0.53125, 0.046875, 0.19921875);
                    }
                    RenderItem ir = RenderItem.getInstance();
                    int[][] slots = ContainerRevolver.slotPositions[bulletAmount >= 18 ? 2 : (bulletAmount > 8 ? 1 : 0)];
                    for (int i = 0; i < bulletAmount; ++i) {
                        if (bullets[i] == null) continue;
                        int x = 0;
                        int y = 0;
                        if (i == 0) {
                            x = 29;
                            y = 3;
                        } else if (i - 1 < slots.length) {
                            x = slots[i - 1][0];
                            y = slots[i - 1][1];
                        } else {
                            int ii = i - (slots.length + 1);
                            int n = ii == 0 ? 48 : (ii == 1 ? 29 : (x = ii == 3 ? 2 : 10));
                            y = ii == 1 ? 57 : (ii == 3 ? 30 : (ii == 4 ? 11 : 49));
                        }
                        ir.func_77015_a(ClientUtils.mc().field_71466_p, ClientUtils.mc().field_71446_o, bullets[i], x, y);
                    }
                    RenderHelper.func_74518_a();
                    GL11.glDisable((int)3042);
                    GL11.glPopMatrix();
                } else if (equipped.func_77973_b() instanceof ItemDrill && equipped.func_77960_j() == 0 || equipped.func_77973_b() instanceof ItemChemthrower) {
                    int amount;
                    boolean drill = equipped.func_77973_b() instanceof ItemDrill;
                    ClientUtils.bindTexture("immersiveengineering:textures/gui/hudElements.png");
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    float dx = event.resolution.func_78326_a() - 16;
                    float dy = event.resolution.func_78328_b();
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)dx, (double)dy, (double)0.0);
                    int w = 31;
                    int h = 62;
                    double uMin = 0.69921875;
                    double uMax = 0.8203125;
                    double vMin = 0.03515625;
                    double vMax = 0.27734375;
                    ClientUtils.drawTexturedRect(-24.0f, -68.0f, (float)w, (float)h, uMin, uMax, vMin, vMax);
                    GL11.glTranslated((double)-23.0, (double)-37.0, (double)0.0);
                    FluidStack fuel = ((IFluidContainerItem)equipped.func_77973_b()).getFluid(equipped);
                    int n = amount = fuel != null ? fuel.amount : 0;
                    if (!drill && player.func_71039_bw()) {
                        amount -= player.func_71057_bx() * Config.getInt("chemthrower_consumption");
                    }
                    float cap = ((IFluidContainerItem)equipped.func_77973_b()).getCapacity(equipped);
                    float angle = 83.0f - (float)(166 * amount) / cap;
                    GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
                    ClientUtils.drawTexturedRect(6.0f, -2.0f, 24.0f, 4.0f, 0.35546875, 0.48046875, 0.3125, 0.33984375);
                    GL11.glRotatef((float)(-angle), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslated((double)23.0, (double)37.0, (double)0.0);
                    if (drill) {
                        ClientUtils.drawTexturedRect(-54.0f, -73.0f, 66.0f, 72.0f, 0.421875, 0.6796875, 0.015625, 0.296875);
                        RenderItem ir = RenderItem.getInstance();
                        ItemStack head = ((ItemDrill)equipped.func_77973_b()).getHead(equipped);
                        if (head != null) {
                            ir.func_77015_a(ClientUtils.mc().field_71466_p, ClientUtils.mc().field_71446_o, head, -51, -45);
                            ir.func_77021_b(ClientUtils.font(), ClientUtils.mc().field_71446_o, head, -51, -45);
                            RenderHelper.func_74518_a();
                        }
                    } else {
                        ClientUtils.drawTexturedRect(-41.0f, -73.0f, 53.0f, 72.0f, 0.03125, 0.23828125, 0.015625, 0.296875);
                        boolean ignite = ItemNBTHelper.getBoolean(equipped, "ignite");
                        ClientUtils.drawTexturedRect(-32.0f, -43.0f, 12.0f, 12.0f, 0.2578125, 0.3046875, (float)(ignite ? 21 : 9) / 256.0f, (float)(ignite ? 33 : 21) / 256.0f);
                    }
                    GL11.glPopMatrix();
                }
                if ((mop = ClientUtils.mc().field_71476_x) != null) {
                    tileEntity = player.field_70170_p.func_147438_o(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                    if (OreDictionary.itemMatches((ItemStack)new ItemStack((Item)IEContent.itemTool, 1, 2), (ItemStack)equipped, (boolean)true)) {
                        int col = Config.getBoolean("nixietubeFont") ? 0xFF9900 : 0xFFFFFF;
                        String[] text = null;
                        if (tileEntity instanceof IEnergyReceiver) {
                            ForgeDirection fd = ForgeDirection.getOrientation((int)mop.field_72310_e);
                            int maxStorage = ((IEnergyReceiver)tileEntity).getMaxEnergyStored(fd);
                            int storage = ((IEnergyReceiver)tileEntity).getEnergyStored(fd);
                            if (maxStorage > 0) {
                                text = StatCollector.func_74837_a((String)"desc.ImmersiveEngineering.info.energyStored", (Object[])new Object[]{"<br>" + Utils.toScientificNotation(storage, "0##", 100000) + " / " + Utils.toScientificNotation(maxStorage, "0##", 100000)}).split("<br>");
                            }
                        } else if (Lib.GREG && GregTechHelper.gregtech_isValidEnergyOutput(tileEntity)) {
                            String gregStored = GregTechHelper.gregtech_getEnergyStored(tileEntity);
                            if (gregStored != null) {
                                text = StatCollector.func_74837_a((String)"desc.ImmersiveEngineering.info.energyStored", (Object[])new Object[]{"<br>" + gregStored}).split("<br>");
                            }
                        } else if (mop.field_72308_g instanceof IEnergyReceiver) {
                            int maxStorage = ((IEnergyReceiver)mop.field_72308_g).getMaxEnergyStored(ForgeDirection.UNKNOWN);
                            int storage = ((IEnergyReceiver)mop.field_72308_g).getEnergyStored(ForgeDirection.UNKNOWN);
                            if (maxStorage > 0) {
                                text = StatCollector.func_74837_a((String)"desc.ImmersiveEngineering.info.energyStored", (Object[])new Object[]{"<br>" + Utils.toScientificNotation(storage, "0##", 100000) + " / " + Utils.toScientificNotation(maxStorage, "0##", 100000)}).split("<br>");
                            }
                        }
                        if (text != null) {
                            if (player.field_70170_p.func_82737_E() % 20L == 0L) {
                                ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageRequestBlockUpdate(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, player.field_71093_bK));
                            }
                            int i = 0;
                            for (String s : text) {
                                if (s == null) continue;
                                int w = ClientProxy.nixieFontOptional.func_78256_a(s);
                                ClientProxy.nixieFontOptional.func_85187_a(s, event.resolution.func_78326_a() / 2 - w / 2, event.resolution.func_78328_b() / 2 - 4 - text.length * (ClientProxy.nixieFontOptional.field_78288_b + 2) + i++ * (ClientProxy.nixieFontOptional.field_78288_b + 2), col, true);
                            }
                        }
                    }
                }
            }
            if (ClientUtils.mc().field_71476_x != null) {
                boolean hammer = player.func_71045_bC() != null ? Utils.isHammer(player.func_71045_bC()) : false;
                mop = ClientUtils.mc().field_71476_x;
                tileEntity = player.field_70170_p.func_147438_o(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                if (tileEntity instanceof IEBlockInterfaces.IBlockOverlayText) {
                    IEBlockInterfaces.IBlockOverlayText overlayBlock = (IEBlockInterfaces.IBlockOverlayText)tileEntity;
                    String[] text = overlayBlock.getOverlayText((EntityPlayer)ClientUtils.mc().field_71439_g, mop, hammer);
                    boolean useNixie = overlayBlock.useNixieFont((EntityPlayer)ClientUtils.mc().field_71439_g, mop);
                    if (text != null && text.length > 0) {
                        FontRenderer font = useNixie ? ClientProxy.nixieFontOptional : ClientUtils.font();
                        int col = useNixie && Config.getBoolean("nixietubeFont") ? 0xFF9900 : 0xFFFFFF;
                        int i = 0;
                        for (String s : text) {
                            if (s == null) continue;
                            font.func_85187_a(s, event.resolution.func_78326_a() / 2 + 8, event.resolution.func_78328_b() / 2 + 8 + i++ * font.field_78288_b, col, true);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onFOVUpdate(FOVUpdateEvent event) {
        EntityClientPlayerMP player = ClientUtils.mc().field_71439_g;
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ZoomHandler.IZoomTool) {
            if (player.func_70093_af() && player.field_70122_E) {
                ItemStack equipped = player.func_71045_bC();
                ZoomHandler.IZoomTool tool = (ZoomHandler.IZoomTool)equipped.func_77973_b();
                if (tool.canZoom(equipped, (EntityPlayer)player)) {
                    if (!ZoomHandler.isZooming) {
                        float[] steps = tool.getZoomSteps(equipped, (EntityPlayer)player);
                        if (steps != null && steps.length > 0) {
                            int curStep = -1;
                            float dist = 0.0f;
                            for (int i = 0; i < steps.length; ++i) {
                                if (curStep != -1 && !(Math.abs(steps[i] - ZoomHandler.fovZoom) < dist)) continue;
                                curStep = i;
                                dist = Math.abs(steps[i] - ZoomHandler.fovZoom);
                            }
                            ZoomHandler.fovZoom = curStep != -1 ? steps[curStep] : event.fov;
                        }
                        ZoomHandler.isZooming = true;
                    }
                    event.newfov = ZoomHandler.fovZoom;
                } else if (ZoomHandler.isZooming) {
                    ZoomHandler.isZooming = false;
                }
            } else if (ZoomHandler.isZooming) {
                ZoomHandler.isZooming = false;
            }
        } else if (ZoomHandler.isZooming) {
            ZoomHandler.isZooming = false;
        }
    }

    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        float[] steps;
        ItemStack equipped;
        ZoomHandler.IZoomTool tool;
        EntityClientPlayerMP player;
        if (event.dwheel != 0 && (player = ClientUtils.mc().field_71439_g).func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ZoomHandler.IZoomTool && player.func_70093_af() && (tool = (ZoomHandler.IZoomTool)(equipped = player.func_71045_bC()).func_77973_b()).canZoom(equipped, (EntityPlayer)player) && (steps = tool.getZoomSteps(equipped, (EntityPlayer)player)) != null && steps.length > 0) {
            int curStep = -1;
            float dist = 0.0f;
            for (int i = 0; i < steps.length; ++i) {
                if (curStep != -1 && !(Math.abs(steps[i] - ZoomHandler.fovZoom) < dist)) continue;
                curStep = i;
                dist = Math.abs(steps[i] - ZoomHandler.fovZoom);
            }
            if (curStep != -1) {
                int newStep = curStep + (event.dwheel > 0 ? -1 : 1);
                if (newStep >= 0 && newStep < steps.length) {
                    ZoomHandler.fovZoom = steps[newStep];
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void renderAdditionalBlockBounds(DrawBlockHighlightEvent event) {
        if (event.subID == 0 && event.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            ItemStack head;
            float f1 = 0.002f;
            double d0 = event.player.field_70142_S + (event.player.field_70165_t - event.player.field_70142_S) * (double)event.partialTicks;
            double d1 = event.player.field_70137_T + (event.player.field_70163_u - event.player.field_70137_T) * (double)event.partialTicks;
            double d2 = event.player.field_70136_U + (event.player.field_70161_v - event.player.field_70136_U) * (double)event.partialTicks;
            if (event.player.field_70170_p.func_147439_a(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d) instanceof IEBlockInterfaces.ICustomBoundingboxes) {
                ChunkCoordinates cc = new ChunkCoordinates(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d);
                IEBlockInterfaces.ICustomBoundingboxes block = (IEBlockInterfaces.ICustomBoundingboxes)event.player.field_70170_p.func_147439_a(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d);
                ArrayList<AxisAlignedBB> set = block.addCustomSelectionBoxesToList(event.player.field_70170_p, cc.field_71574_a, cc.field_71572_b, cc.field_71573_c);
                if (!set.isEmpty()) {
                    GL11.glEnable((int)3042);
                    OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                    GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                    GL11.glLineWidth((float)2.0f);
                    GL11.glDisable((int)3553);
                    GL11.glDepthMask((boolean)false);
                    ArrayList<AxisAlignedBB> specialBoxes = new ArrayList<AxisAlignedBB>();
                    AxisAlignedBB overrideBox = null;
                    for (AxisAlignedBB aabb : set) {
                        boolean b;
                        if (aabb == null || !(b = block.addSpecifiedSubBox(event.player.field_70170_p, cc.field_71574_a, cc.field_71572_b, cc.field_71573_c, event.player, aabb, event.target.field_72307_f, specialBoxes))) continue;
                        overrideBox = specialBoxes.get(specialBoxes.size() - 1);
                    }
                    if (overrideBox != null) {
                        ClientEventHandler.renderBoundingBox(overrideBox, (double)cc.field_71574_a - d0, (double)cc.field_71572_b - d1, (double)cc.field_71573_c - d2, f1);
                    } else {
                        for (AxisAlignedBB aabb : specialBoxes.isEmpty() ? set : specialBoxes) {
                            if (aabb == null) continue;
                            ClientEventHandler.renderBoundingBox(aabb, (double)cc.field_71574_a - d0, (double)cc.field_71572_b - d1, (double)cc.field_71573_c - d2, f1);
                        }
                    }
                    GL11.glDepthMask((boolean)true);
                    GL11.glEnable((int)3553);
                    GL11.glDisable((int)3042);
                    event.setCanceled(true);
                }
            }
            ItemStack stack = event.player.func_71045_bC();
            World world = event.player.field_70170_p;
            if (stack != null && stack.func_77973_b() instanceof ItemDrill && ((ItemDrill)stack.func_77973_b()).isEffective(world.func_147439_a(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d).func_149688_o()) && (head = ((ItemDrill)stack.func_77973_b()).getHead(stack)) != null) {
                int side = event.target.field_72310_e;
                int diameter = ((IDrillHead)head.func_77973_b()).getMiningSize(head) + ((ItemDrill)stack.func_77973_b()).getUpgrades(stack).func_74762_e("size");
                int depth = ((IDrillHead)head.func_77973_b()).getMiningDepth(head) + ((ItemDrill)stack.func_77973_b()).getUpgrades(stack).func_74762_e("depth");
                int startX = event.target.field_72311_b;
                int startY = event.target.field_72312_c;
                int startZ = event.target.field_72309_d;
                if (diameter % 2 == 0) {
                    float hx = (float)event.target.field_72307_f.field_72450_a - (float)event.target.field_72311_b;
                    float hy = (float)event.target.field_72307_f.field_72448_b - (float)event.target.field_72312_c;
                    float hz = (float)event.target.field_72307_f.field_72449_c - (float)event.target.field_72309_d;
                    if (side < 2 && (double)hx < 0.5 || side < 4 && (double)hx < 0.5) {
                        startX -= diameter / 2;
                    }
                    if (side > 1 && (double)hy < 0.5) {
                        startY -= diameter / 2;
                    }
                    if (side < 2 && (double)hz < 0.5 || side > 3 && (double)hz < 0.5) {
                        startZ -= diameter / 2;
                    }
                } else {
                    startX -= side == 4 || side == 5 ? 0 : diameter / 2;
                    startY -= side == 0 || side == 1 ? 0 : diameter / 2;
                    startZ -= side == 2 || side == 3 ? 0 : diameter / 2;
                }
                GL11.glColor4f((float)0.1f, (float)0.1f, (float)0.1f, (float)0.4f);
                GL11.glLineWidth((float)1.0f);
                GL11.glDisable((int)3553);
                for (int dd = 0; dd < depth; ++dd) {
                    for (int dw = 0; dw < diameter; ++dw) {
                        for (int dh = 0; dh < diameter; ++dh) {
                            AxisAlignedBB aabb;
                            int z;
                            int y;
                            int x = startX + (side == 4 || side == 5 ? dd : dw);
                            Block block = event.player.field_70170_p.func_147439_a(x, y = startY + (side == 0 || side == 1 ? dd : dh), z = startZ + (side == 0 || side == 1 ? dh : (side == 4 || side == 5 ? dw : dd)));
                            if (block == null || block.isAir((IBlockAccess)world, x, y, z) || block.func_149737_a(event.player, world, x, y, z) == 0.0f || !((ItemDrill)stack.func_77973_b()).canBreakExtraBlock(world, block, x, y, z, world.func_72805_g(x, y, z), event.player, stack, head, false) || (aabb = block.func_149633_g(event.player.field_70170_p, x, y, z)) == null) continue;
                            RenderGlobal.func_147590_a((AxisAlignedBB)aabb.func_72314_b((double)f1, (double)f1, (double)f1).func_72325_c(-d0, -d1, -d2), (int)-1);
                        }
                    }
                }
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)3553);
                GL11.glDisable((int)3042);
            }
        }
    }

    static void renderBoundingBox(AxisAlignedBB aabb, double offsetX, double offsetY, double offsetZ, float expand) {
        if (aabb instanceof AdvancedAABB && ((AdvancedAABB)aabb).drawOverride != null && ((AdvancedAABB)aabb).drawOverride.length > 0) {
            double midX = aabb.field_72340_a + (aabb.field_72336_d - aabb.field_72340_a) / 2.0;
            double midY = aabb.field_72338_b + (aabb.field_72337_e - aabb.field_72338_b) / 2.0;
            double midZ = aabb.field_72339_c + (aabb.field_72334_f - aabb.field_72339_c) / 2.0;
            ClientUtils.tes().func_78372_c((float)offsetX, (float)offsetY, (float)offsetZ);
            for (Vec3[] face : ((AdvancedAABB)aabb).drawOverride) {
                ClientUtils.tes().func_78371_b(2);
                for (Vec3 v : face) {
                    ClientUtils.tes().func_78377_a(v.field_72450_a + (double)(v.field_72450_a < midX ? -expand : expand), v.field_72448_b + (double)(v.field_72448_b < midY ? -expand : expand), v.field_72449_c + (double)(v.field_72449_c < midZ ? -expand : expand));
                }
                ClientUtils.tes().func_78381_a();
            }
            ClientUtils.tes().func_78372_c((float)(-offsetX), (float)(-offsetY), (float)(-offsetZ));
        } else {
            RenderGlobal.func_147590_a((AxisAlignedBB)aabb.func_72325_c(offsetX, offsetY, offsetZ).func_72314_b((double)expand, (double)expand, (double)expand), (int)-1);
        }
    }

    @SubscribeEvent
    public void onClientDeath(LivingDeathEvent event) {
    }

    @SubscribeEvent
    public void onRenderLivingPre(RenderLivingEvent.Pre event) {
        if (event.entity.getEntityData().func_74764_b("headshot")) {
            ModelBase model = event.renderer.field_77045_g;
            if (model instanceof ModelBiped) {
                ((ModelBiped)model).field_78116_c.field_78806_j = false;
            } else if (model instanceof ModelVillager) {
                ((ModelVillager)model).field_78191_a.field_78806_j = false;
            }
        }
    }

    @SubscribeEvent
    public void onRenderLivingPost(RenderLivingEvent.Post event) {
        if (event.entity.getEntityData().func_74764_b("headshot")) {
            ModelBase model = event.renderer.field_77045_g;
            if (model instanceof ModelBiped) {
                ((ModelBiped)model).field_78116_c.field_78806_j = true;
            } else if (model instanceof ModelVillager) {
                ((ModelVillager)model).field_78191_a.field_78806_j = true;
            }
        }
    }

    static {
        skyhookGrabableConnections = new HashSet<ImmersiveNetHandler.Connection>();
        connectionsRendered = false;
    }
}

