/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.extratrees.dictionary;

import binnie.core.machines.Machine;
import binnie.craftgui.core.CraftGUI;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.IPoint;
import binnie.craftgui.core.geometry.Position;
import binnie.craftgui.events.EventHandler;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.minecraft.control.ControlProgressBase;
import binnie.craftgui.resource.Texture;
import binnie.craftgui.resource.minecraft.StandardTexture;
import binnie.extratrees.core.ExtraTreeTexture;
import binnie.extratrees.machines.Distillery;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class ControlDistilleryProgress
extends ControlProgressBase {
    static Texture DistilleryBase = new StandardTexture(43, 0, 58, 66, ExtraTreeTexture.Gui);
    static Texture DistilleryOverlay = new StandardTexture(139, 0, 18, 66, ExtraTreeTexture.Gui);
    static Texture LiquidFlow = new StandardTexture(101, 0, 38, 66, ExtraTreeTexture.Gui);
    static Texture Output = new StandardTexture(68, 66, 17, 7, ExtraTreeTexture.Gui);

    @Override
    public void onRenderBackground() {
        CraftGUI.Render.texture(DistilleryBase, new IPoint(0.0f, 0.0f));
        CraftGUI.Render.texturePercentage(LiquidFlow, new IArea(18.0f, 0.0f, 38.0f, 66.0f), Position.Left, this.progress);
        Distillery.ComponentDistilleryLogic component = Machine.getInterface(Distillery.ComponentDistilleryLogic.class, ((Window)Window.get(this)).getInventory());
        FluidStack stack = null;
        if (component != null) {
            stack = component.currentFluid;
        }
        if (stack != null) {
            for (int y = 0; y < 4; ++y) {
                this.renderFluid(stack, new IPoint(1.0f, 1 + y * 16));
            }
        }
    }

    @Override
    public void onRenderForeground() {
        int level = Machine.getInterface(Distillery.ComponentDistilleryLogic.class, (Object)((Window)Window.get((IWidget)this)).getInventory()).level;
        CraftGUI.Render.texture(Output, new IPoint(47.0f, 14 + level * 15));
        CraftGUI.Render.texture(DistilleryOverlay, new IPoint(0.0f, 0.0f));
    }

    protected ControlDistilleryProgress(IWidget parent, float x, float y) {
        super(parent, x, y, 58.0f, 66.0f);
        this.addSelfEventHandler((EventHandler)new EventMouse.Down.Handler(){

            @Override
            public void onEvent(EventMouse.Down event) {
                int distillationLevel = -1;
                if (new IArea(45.0f, 8.0f, 19.0f, 11.0f).contains(ControlDistilleryProgress.this.getRelativeMousePosition())) {
                    distillationLevel = 0;
                } else if (new IArea(45.0f, 23.0f, 19.0f, 11.0f).contains(ControlDistilleryProgress.this.getRelativeMousePosition())) {
                    distillationLevel = 1;
                } else if (new IArea(45.0f, 38.0f, 19.0f, 11.0f).contains(ControlDistilleryProgress.this.getRelativeMousePosition())) {
                    distillationLevel = 2;
                }
                if (distillationLevel >= 0) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74774_a("i", (byte)distillationLevel);
                    ((Window)Window.get(ControlDistilleryProgress.this.getWidget())).sendClientAction("still-level", nbt);
                }
            }
        });
    }

    public void renderFluid(FluidStack fluid, IPoint pos) {
        int hex = fluid.getFluid().getColor(fluid);
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        IIcon icon = fluid.getFluid().getIcon();
        GL11.glColor4f((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        CraftGUI.Render.iconBlock(pos, fluid.getFluid().getIcon());
        GL11.glDisable((int)3042);
    }
}

