/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.block;

import binnie.core.block.BlockMetadata;
import binnie.core.block.IBlockMetadata;
import binnie.core.block.TileEntityMetadata;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.block.ILogType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBranch
extends BlockLog
implements IBlockMetadata {
    public BlockBranch() {
        this.func_149647_a(Tabs.tabArboriculture);
        this.func_149663_c("branch");
        this.func_149752_b(5.0f);
        this.func_149711_c(2.0f);
        this.func_149672_a(field_149766_f);
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List itemList) {
        for (int i = 0; i < ILogType.ExtraTreeLog.values().length; ++i) {
            itemList.add(TileEntityMetadata.getItemStack((Block)this, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityMetadata tile = TileEntityMetadata.getTile(world, x, y, z);
        if (tile != null) {
            return this.getIcon(side, tile.getTileMetadata(), world.func_72805_g(x, y, z));
        }
        return super.func_149673_e(world, x, y, z, side);
    }

    public IIcon getIcon(int side, int tileMeta, int blockMeta) {
        int oriented = blockMeta & 0xC;
        ILogType.ExtraTreeLog log = ILogType.ExtraTreeLog.values()[tileMeta];
        if (side > 3) {
            return log.getTrunk();
        }
        return log.getBark();
    }

    public IIcon func_149691_a(int side, int tileMeta) {
        return this.getIcon(side, tileMeta, 0);
    }

    public int func_149645_b() {
        return ExtraTrees.branchRenderId;
    }

    @Override
    public void dropAsStack(World world, int x, int y, int z, ItemStack drop) {
        this.func_149642_a(world, x, y, z, drop);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int blockMeta, int fortune) {
        return BlockMetadata.getBlockDropped(this, world, x, y, z, blockMeta);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        return BlockMetadata.breakBlock(this, player, world, x, y, z);
    }

    public TileEntity func_149915_a(World var1, int i) {
        return new TileEntityMetadata();
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public boolean func_149696_a(World par1World, int par2, int par3, int par4, int par5, int par6) {
        super.func_149696_a(par1World, par2, par3, par4, par5, par6);
        TileEntity tileentity = par1World.func_147438_o(par2, par3, par4);
        return tileentity != null ? tileentity.func_145842_c(par5, par6) : false;
    }

    @Override
    public int getDroppedMeta(int blockMeta, int tileMeta) {
        return tileMeta;
    }

    @Override
    public String getBlockName(ItemStack par1ItemStack) {
        int meta = TileEntityMetadata.getItemDamage(par1ItemStack);
        return ILogType.ExtraTreeLog.values()[meta].getName() + " Branch";
    }

    @Override
    public void getBlockTooltip(ItemStack par1ItemStack, List par3List) {
    }

    @Override
    public int getPlacedMeta(ItemStack stack, World world, int x, int y, int z, ForgeDirection clickedBlock) {
        return TileEntityMetadata.getItemDamage(stack);
    }

    public void func_149749_a(World par1World, int par2, int par3, int par4, Block par5, int par6) {
        super.func_149749_a(par1World, par2, par3, par4, par5, par6);
        par1World.func_147475_p(par2, par3, par4);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return BlockMetadata.getPickBlock(world, x, y, z);
    }
}

