/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui;

import binnie.craftgui.controls.ControlText;
import binnie.craftgui.controls.ControlTextCentered;
import binnie.craftgui.core.CraftGUI;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.IPoint;
import binnie.craftgui.core.geometry.TextJustification;
import binnie.genetics.gui.ControlAnalystPage;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;

public class AnalystPageDescription
extends ControlAnalystPage {
    public AnalystPageDescription(IWidget parent, IArea area, IIndividual ind) {
        super(parent, area);
        this.setColour(0x333333);
        int y = 4;
        IAlleleSpecies species = ind.getGenome().getPrimary();
        String branchBinomial = species.getBranch() != null ? species.getBranch().getScientific() : "<Unknown>";
        String branchName = species.getBranch() != null ? species.getBranch().getName() : "Unknown";
        String desc = species.getDescription();
        String descBody = "\u00a7o";
        String descSig = "";
        if (desc == null || desc == "" || desc.contains("for.description")) {
            descBody = descBody + "";
        } else {
            String[] descStrings = desc.split("\\|");
            descBody = descBody + descStrings[0];
            for (int i = 1; i < descStrings.length - 1; ++i) {
                descBody = descBody + " " + descStrings[i];
            }
            if (descStrings.length > 1) {
                descSig = descSig + descStrings[descStrings.length - 1];
            }
        }
        String authority = species.getAuthority();
        if (authority.contains("Binnie")) {
            authority = "\u00a71\u00a7l" + authority;
        }
        if (authority.contains("Sengir")) {
            authority = "\u00a72\u00a7l" + authority;
        }
        if (authority.contains("MysteriousAges")) {
            authority = "\u00a75\u00a7l" + authority;
        }
        new ControlTextCentered((IWidget)this, y, "\u00a7nDescription").setColour(this.getColour());
        new ControlTextCentered((IWidget)this, y += 16, species.getName() + "\u00a7r").setColour(this.getColour());
        new ControlTextCentered((IWidget)this, y += 10, "\u00a7o" + branchBinomial + " " + species.getBinomial() + "\u00a7r").setColour(this.getColour());
        new ControlTextCentered((IWidget)this, y += 20, "Discovered by \u00a7l" + authority + "\u00a7r").setColour(this.getColour());
        y = (int)((float)y + (3.0f + CraftGUI.Render.textHeight("Discovered by \u00a7l" + authority + "\u00a7r", this.w())));
        new ControlTextCentered((IWidget)this, y, "Genetic Complexity: " + species.getComplexity()).setColour(this.getColour());
        ControlText descText = new ControlText(this, new IArea(8.0f, y += 26, this.w() - 16.0f, 0.0f), descBody + "\u00a7r", TextJustification.TopCenter);
        ControlText signatureText = new ControlText(this, new IArea(8.0f, y, this.w() - 16.0f, 0.0f), descSig + "\u00a7r", TextJustification.BottomRight);
        descText.setColour(this.getColour());
        signatureText.setColour(this.getColour());
        float descHeight = CraftGUI.Render.textHeight(descText.getValue(), descText.getSize().x());
        signatureText.setPosition(new IPoint(signatureText.pos().x(), descText.getPosition().y() + descHeight + 10.0f));
        this.setSize(new IPoint(this.w(), 20.0f + signatureText.y()));
    }

    @Override
    public String getTitle() {
        return "Description";
    }
}

