/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui;

import binnie.Binnie;
import binnie.botany.Botany;
import binnie.botany.api.EnumAcidity;
import binnie.botany.api.EnumMoisture;
import binnie.botany.api.IFlower;
import binnie.botany.gardening.BlockSoil;
import binnie.core.genetics.Tolerance;
import binnie.craftgui.controls.ControlText;
import binnie.craftgui.controls.ControlTextCentered;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.TextJustification;
import binnie.craftgui.minecraft.control.ControlItemDisplay;
import binnie.genetics.gui.ControlAnalystPage;
import binnie.genetics.gui.ControlToleranceBar;
import forestry.api.genetics.EnumTolerance;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class AnalystPageSoil
extends ControlAnalystPage {
    public AnalystPageSoil(IWidget parent, IArea area, IFlower flower) {
        super(parent, area);
        this.setColour(0x663300);
        EnumMoisture moisture = flower.getGenome().getPrimary().getMoisture();
        EnumTolerance moistureTol = flower.getGenome().getToleranceMoisture();
        EnumAcidity pH = flower.getGenome().getPrimary().getPH();
        EnumTolerance pHTol = flower.getGenome().getTolerancePH();
        int y = 4;
        new ControlTextCentered((IWidget)this, y, "\u00a7nSoil").setColour(this.getColour());
        new ControlText(this, new IArea(4.0f, y += 16, this.w() - 8.0f, 14.0f), "Moisture Tolerance", TextJustification.MiddleCenter).setColour(this.getColour());
        this.createMoisture(this, (this.w() - 100.0f) / 2.0f, y += 12, 100.0f, 10.0f, moisture, moistureTol);
        new ControlText(this, new IArea(4.0f, y += 16, this.w() - 8.0f, 14.0f), "pH Tolerance", TextJustification.MiddleCenter).setColour(this.getColour());
        this.createAcidity(this, (this.w() - 100.0f) / 2.0f, y += 12, 100.0f, 10.0f, pH, pHTol);
        new ControlText(this, new IArea(4.0f, y += 16, this.w() - 8.0f, 14.0f), "Recommended Soil", TextJustification.MiddleCenter).setColour(this.getColour());
        y += 12;
        EnumMoisture recomMoisture = EnumMoisture.Normal;
        boolean canTolNormal = Tolerance.canTolerate(moisture, EnumMoisture.Normal, moistureTol);
        boolean canTolDamp = Tolerance.canTolerate(moisture, EnumMoisture.Damp, moistureTol);
        boolean canTolDry = Tolerance.canTolerate(moisture, EnumMoisture.Dry, moistureTol);
        if (canTolNormal) {
            if (canTolDamp && !canTolDry) {
                recomMoisture = EnumMoisture.Damp;
            } else if (canTolDry && !canTolDamp) {
                recomMoisture = EnumMoisture.Dry;
            }
        } else {
            if (canTolDamp) {
                recomMoisture = EnumMoisture.Damp;
            }
            if (canTolDry) {
                recomMoisture = EnumMoisture.Dry;
            }
        }
        EnumAcidity recomPH = EnumAcidity.Neutral;
        boolean canTolNeutral = Tolerance.canTolerate(pH, EnumAcidity.Neutral, pHTol);
        boolean canTolAcid = Tolerance.canTolerate(pH, EnumAcidity.Acid, pHTol);
        boolean canTolAlkaline = Tolerance.canTolerate(pH, EnumAcidity.Alkaline, pHTol);
        if (canTolNeutral) {
            if (canTolAcid && !canTolAlkaline) {
                recomPH = EnumAcidity.Acid;
            } else if (canTolAlkaline && !canTolAcid) {
                recomPH = EnumAcidity.Alkaline;
            }
        } else {
            if (canTolAcid) {
                recomPH = EnumAcidity.Acid;
            }
            if (canTolAlkaline) {
                recomPH = EnumAcidity.Alkaline;
            }
        }
        ItemStack stack = new ItemStack((Block)Botany.soil, 1, BlockSoil.getMeta(recomPH, recomMoisture));
        ControlItemDisplay recomSoil = new ControlItemDisplay(this, (this.w() - 24.0f) / 2.0f, y, 24.0f);
        recomSoil.setItemStack(stack);
        recomSoil.setTooltip();
        new ControlText(this, new IArea(4.0f, y += 32, this.w() - 8.0f, 14.0f), "Other Soils", TextJustification.MiddleCenter).setColour(this.getColour());
        y += 12;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (EnumAcidity a : EnumSet.range(EnumAcidity.Acid, EnumAcidity.Alkaline)) {
            for (EnumMoisture b : EnumSet.range(EnumMoisture.Dry, EnumMoisture.Damp)) {
                if (!Tolerance.canTolerate(pH, a, pHTol) || !Tolerance.canTolerate(moisture, b, moistureTol) || a == recomPH && b == recomMoisture) continue;
                stacks.add(new ItemStack((Block)Botany.soil, 1, BlockSoil.getMeta(a, b)));
            }
        }
        float soilListWidth = 17 * stacks.size() - 1;
        float soilListX = (this.w() - soilListWidth) / 2.0f;
        int t = 0;
        for (ItemStack soilStack : stacks) {
            ControlItemDisplay display = new ControlItemDisplay(this, soilListX + (float)(17 * t++), y);
            display.setItemStack(soilStack);
            display.setTooltip();
        }
    }

    protected void createMoisture(IWidget parent, float x, float y, float w, float h, EnumMoisture value, EnumTolerance tol) {
        new ControlToleranceBar<EnumMoisture>(parent, x, y, w, h, EnumMoisture.class){

            @Override
            protected String getName(EnumMoisture value) {
                return Binnie.Language.localise((Object)value);
            }

            @Override
            protected int getColour(EnumMoisture value) {
                return (new int[]{0xCCFFCC, 0x66CCFF, 0x3366FF})[value.ordinal()];
            }
        }.setValues(value, tol);
    }

    protected void createAcidity(IWidget parent, float x, float y, float w, float h, EnumAcidity value, EnumTolerance tol) {
        new ControlToleranceBar<EnumAcidity>(parent, x, y, w, h, EnumAcidity.class){

            @Override
            protected String getName(EnumAcidity value) {
                return Binnie.Language.localise((Object)value);
            }

            @Override
            protected int getColour(EnumAcidity value) {
                return (new int[]{0xFF0066, 65280, 26367})[value.ordinal()];
            }
        }.setValues(value, tol);
    }

    @Override
    public String getTitle() {
        return "Soil";
    }
}

