/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.storage;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mcjty.lib.varia.Logging;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.storage.ModularStorageConfiguration;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.rftools.items.storage.StorageModuleItem;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class StorageModuleTabletItem
extends Item
implements IEnergyContainerItem {
    private int capacity;
    private int maxReceive;
    private int maxExtract;
    private IIcon iconFull;
    private IIcon iconEmpty;
    public static final int DAMAGE_EMPTY = 0;
    public static final int DAMAGE_FULL = 1;

    public StorageModuleTabletItem() {
        this.func_77625_d(1);
        this.capacity = ModularStorageConfiguration.TABLET_MAXENERGY;
        this.maxReceive = ModularStorageConfiguration.TABLET_RECEIVEPERTICK;
        this.maxExtract = ModularStorageConfiguration.TABLET_CONSUMEPERUSE;
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.iconFull = iconRegister.func_94245_a("rftools:storage/storageModuleTablet");
        this.iconEmpty = iconRegister.func_94245_a("rftools:storage/storageModuleTabletEmpty");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        if (damage == 0) {
            return this.iconEmpty;
        }
        return this.iconFull;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            int energy;
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound == null || !tagCompound.func_74764_b("childDamage")) {
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.YELLOW + "This tablet contains no storage module!"));
                return stack;
            }
            int moduleDamage = tagCompound.func_74762_e("childDamage");
            int rfNeeded = ModularStorageConfiguration.TABLET_CONSUMEPERUSE;
            if (moduleDamage != 6) {
                rfNeeded += ModularStorageConfiguration.TABLET_EXTRACONSUME * (moduleDamage + 1);
            }
            if ((energy = tagCompound.func_74762_e("Energy")) < rfNeeded) {
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.YELLOW + "Not enough energy to open the contents!"));
                return stack;
            }
            tagCompound.func_74768_a("Energy", energy -= rfNeeded);
            if (moduleDamage == 6) {
                if (!tagCompound.func_74764_b("id")) {
                    Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.YELLOW + "This remote storage module is not linked!"));
                    return stack;
                }
                player.openGui((Object)RFTools.instance, RFTools.GUI_REMOTE_STORAGE_ITEM, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            } else {
                player.openGui((Object)RFTools.instance, RFTools.GUI_MODULAR_STORAGE_ITEM, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            }
            return stack;
        }
        return stack;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return stack.func_77960_j() == 1;
    }

    public Item func_77668_q() {
        return ModularStorageSetup.storageModuleTabletItem;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (this.hasContainerItem(stack) && stack.func_77942_o()) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74768_a("Energy", stack.func_77978_p().func_74762_e("Energy"));
            ItemStack container = new ItemStack(this.func_77668_q());
            container.func_77982_d(tagCompound);
            return container;
        }
        return null;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            list.add(EnumChatFormatting.BLUE + "Energy: " + tagCompound.func_74762_e("Energy") + " RF");
            if (itemStack.func_77960_j() == 1) {
                int max = StorageModuleItem.MAXSIZE[tagCompound.func_74762_e("childDamage")];
                StorageModuleItem.addModuleInformation(list, max, tagCompound);
            } else {
                list.add(EnumChatFormatting.YELLOW + "No storage module installed!");
            }
        }
        list.add("This RF/charged module can hold a storage module");
        list.add("and allows the wielder to manipulate the contents of");
        list.add("this module (remote or normal).");
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyReceived = Math.min(this.capacity - energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        return container.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.capacity;
    }
}

