/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration.mods.harvestcraft;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import com.pam.harvestcraft.GuiPamApiary;
import com.pam.harvestcraft.ItemRegistry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import tonius.neiintegration.PositionedStackAdv;
import tonius.neiintegration.RecipeHandlerBase;
import tonius.neiintegration.Utils;

public class RecipeHandlerApiary
extends RecipeHandlerBase {
    private static final Map<Item, Float> BEE_PRODUCTS = new LinkedHashMap<Item, Float>();

    @Override
    public String getRecipeID() {
        return "harvestcraft.apiary";
    }

    public String getRecipeName() {
        return Utils.translate("tile.apiary.name", false);
    }

    public String getGuiTexture() {
        return "harvestcraft:textures/gui/apiary.png";
    }

    public void loadTransferRects() {
        this.addTransferRect(3, 44, 49, 11);
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiPamApiary.class;
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)-2, (int)-3, (int)3, (int)8, (int)170, (int)66);
    }

    public int recipiesPerPage() {
        return 1;
    }

    @Override
    public void loadAllRecipes() {
        this.arecipes.add(new CachedApiaryRecipe());
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        if (BEE_PRODUCTS.containsKey(result.func_77973_b())) {
            this.arecipes.add(new CachedApiaryRecipe());
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingred) {
        if (ingred.func_77973_b() == ItemRegistry.queenbeeItem) {
            this.arecipes.add(new CachedApiaryRecipe());
        }
    }

    static {
        BEE_PRODUCTS.put(ItemRegistry.waxcombItem, Float.valueOf(0.5f));
        BEE_PRODUCTS.put(ItemRegistry.honeycombItem, Float.valueOf(0.45f));
        BEE_PRODUCTS.put(ItemRegistry.grubItem, Float.valueOf(0.05f));
    }

    public class CachedApiaryRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        private PositionedStack input;
        private List<PositionedStack> outputs = new ArrayList<PositionedStack>();

        public CachedApiaryRecipe() {
            this.input = new PositionedStack((Object)new ItemStack(ItemRegistry.queenbeeItem), 21, 24);
            int i = 0;
            for (Map.Entry e : BEE_PRODUCTS.entrySet()) {
                this.outputs.add(new PositionedStackAdv(new ItemStack((Item)e.getKey()), 57 + 18 * i, 6).setChance(((Float)e.getValue()).floatValue()));
                ++i;
            }
        }

        public PositionedStack getIngredient() {
            return this.input;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.outputs;
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

