/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration.mods.mcforge.dumpers;

import codechicken.nei.config.DataDumper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import net.minecraft.item.Item;
import net.minecraftforge.fluids.FluidContainerRegistry;

public class FluidContainerDumper
extends DataDumper {
    public FluidContainerDumper() {
        super("tools.dump.neiintegration.fluidcontainer");
    }

    public String[] header() {
        return new String[]{"Fluid", "Amount", "Empty Container", "Empty Container Display Name", "Empty Container Item", "Filled Container", "Filled Container Display Name", "Filled Container Item"};
    }

    public Iterable<String[]> dump(int mode) {
        LinkedList<String[]> list = new LinkedList<String[]>();
        ArrayList<FluidContainerRegistry.FluidContainerData> datas = new ArrayList<FluidContainerRegistry.FluidContainerData>();
        datas.addAll(Arrays.asList(FluidContainerRegistry.getRegisteredFluidContainerData()));
        Collections.sort(datas, new Comparator<FluidContainerRegistry.FluidContainerData>(){

            @Override
            public int compare(FluidContainerRegistry.FluidContainerData d1, FluidContainerRegistry.FluidContainerData d2) {
                return d1.fluid.getFluid().getName().compareTo(d2.fluid.getFluid().getName());
            }
        });
        for (FluidContainerRegistry.FluidContainerData data : datas) {
            String filledDisplayName;
            String emptyDisplayName;
            try {
                emptyDisplayName = data.emptyContainer.func_82833_r();
            }
            catch (Exception e) {
                emptyDisplayName = "-";
            }
            try {
                filledDisplayName = data.filledContainer.func_82833_r();
            }
            catch (Exception e) {
                filledDisplayName = "-";
            }
            list.add(new String[]{data.fluid.getFluid().getName(), String.valueOf(data.fluid.amount), data.emptyContainer.toString(), emptyDisplayName, Item.field_150901_e.func_148750_c((Object)data.emptyContainer.func_77973_b()), data.filledContainer.toString(), filledDisplayName, Item.field_150901_e.func_148750_c((Object)data.filledContainer.func_77973_b())});
        }
        return list;
    }

    public int modeCount() {
        return 1;
    }
}

