/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.HardcoreQuesting;
import hardcorequesting.Translator;
import hardcorequesting.items.ModItems;
import hardcorequesting.quests.Quest;
import hardcorequesting.tileentity.PortalType;
import hardcorequesting.tileentity.TileEntityPortal;
import java.util.List;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPortal
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon transparentIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon emptyIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon techIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon techEmptyIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon magicIcon;

    public BlockPortal() {
        super(Material.field_151575_d);
        this.func_149663_c("hqm:quest_portal");
        this.func_149647_a(HardcoreQuesting.HQMTab);
        this.func_149711_c(10.0f);
    }

    public TileEntity func_149915_a(World world, int i) {
        return new TileEntityPortal();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister icon) {
        this.pickIcons(icon);
    }

    private void pickIcons(IIconRegister icon) {
        this.field_149761_L = icon.func_94245_a("hqm:hqmQuestPortal");
        this.emptyIcon = icon.func_94245_a("hqm:hqmItemBarrelEmpty");
        this.techIcon = icon.func_94245_a("hqm:hqmQuestPortalTech");
        this.techEmptyIcon = icon.func_94245_a("hqm:hqmQuestPortalTechTop");
        this.magicIcon = icon.func_94245_a("hqm:hqmQuestPortalMagic");
        this.transparentIcon = icon.func_94245_a("hqm:hqmQuestPortalTransparent");
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (player != null && Quest.isEditing) {
            TileEntity te;
            if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() == ModItems.book) {
                TileEntity te2;
                if (!world.field_72995_K && (te2 = world.func_147438_o(x, y, z)) != null && te2 instanceof TileEntityPortal) {
                    ((TileEntityPortal)te2).setCurrentQuest();
                    if (((TileEntityPortal)te2).getCurrentQuest() != null) {
                        player.func_146105_b(Translator.translateToIChatComponent("tile.hqm:quest_portal_0.bindTo", ((TileEntityPortal)te2).getCurrentQuest().getName()));
                    } else {
                        player.func_146105_b(Translator.translateToIChatComponent("hqm.message.noTaskSelected", new Object[0]));
                    }
                }
                return true;
            }
            if (!world.field_72995_K && (te = world.func_147438_o(x, y, z)) != null && te instanceof TileEntityPortal) {
                ((TileEntityPortal)te).openInterface(player);
            }
            return true;
        }
        return false;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB box, List lst, Entity entity) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (entity instanceof EntityPlayer && te instanceof TileEntityPortal && !((TileEntityPortal)te).hasCollision((EntityPlayer)entity)) {
            return;
        }
        super.func_149743_a(world, x, y, z, box, lst, entity);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149637_q() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public final IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityPortal) {
            TileEntityPortal portal = (TileEntityPortal)te;
            if (!portal.hasTexture((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                return this.transparentIcon;
            }
            if (portal.getType().isPreset()) {
                return this.getPresetIcon(portal.getType(), side);
            }
            IIcon icon = portal.getBlockIcon(side);
            if (icon != null) {
                return icon;
            }
        }
        return this.func_149691_a(side, 0);
    }

    private IIcon getPresetIcon(PortalType preset, int side) {
        return preset == PortalType.TECH ? (side == 0 || side == 1 ? this.techEmptyIcon : this.techIcon) : this.magicIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta == 1 || meta == 2) {
            return this.getPresetIcon(meta == 1 ? PortalType.TECH : PortalType.MAGIC, side);
        }
        return side == 0 || side == 1 ? this.emptyIcon : this.field_149761_L;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityPortal) {
            TileEntityPortal portal = (TileEntityPortal)te;
            ItemStack itemStack = super.getPickBlock(target, world, x, y, z, player);
            if (itemStack != null) {
                NBTTagCompound tagCompound = itemStack.func_77978_p();
                if (tagCompound == null) {
                    tagCompound = new NBTTagCompound();
                    itemStack.func_77982_d(tagCompound);
                }
                NBTTagCompound info = new NBTTagCompound();
                tagCompound.func_74782_a("Portal", (NBTBase)info);
                portal.writeContentToNBT(info);
            }
            return itemStack;
        }
        return null;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityPortal) {
            TileEntityPortal manager = (TileEntityPortal)te;
            if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("Portal")) {
                manager.readContentFromNBT(itemStack.func_77978_p().func_74775_l("Portal"));
            }
        }
    }
}

