/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.core;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.BiomeHelper;
import forestry.api.core.ForestryAPI;
import net.minecraft.util.IIcon;
import net.minecraft.world.biome.BiomeGenBase;

public enum EnumTemperature {
    NONE("None", "habitats/ocean"),
    ICY("Icy", "habitats/snow"),
    COLD("Cold", "habitats/taiga"),
    NORMAL("Normal", "habitats/plains"),
    WARM("Warm", "habitats/jungle"),
    HOT("Hot", "habitats/desert"),
    HELLISH("Hellish", "habitats/nether");

    public final String name;
    public final String iconIndex;

    private EnumTemperature(String name, String iconIndex) {
        this.name = name;
        this.iconIndex = iconIndex;
    }

    public String getName() {
        return this.name;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return ForestryAPI.textureManager.getDefault(this.iconIndex);
    }

    public static EnumTemperature getFromValue(float rawTemp) {
        if (rawTemp > 1.0f) {
            return HOT;
        }
        if (rawTemp > 0.85f) {
            return WARM;
        }
        if (rawTemp > 0.35f) {
            return NORMAL;
        }
        if (rawTemp > 0.0f) {
            return COLD;
        }
        return ICY;
    }

    public static EnumTemperature getFromBiome(BiomeGenBase biomeGenBase) {
        if (BiomeHelper.isBiomeHellish(biomeGenBase)) {
            return HELLISH;
        }
        return EnumTemperature.getFromValue(biomeGenBase.field_76750_F);
    }

    public static EnumTemperature getFromBiome(BiomeGenBase biomeGenBase, int x, int y, int z) {
        if (BiomeHelper.isBiomeHellish(biomeGenBase)) {
            return HELLISH;
        }
        float temperature = biomeGenBase.func_150564_a(x, y, z);
        return EnumTemperature.getFromValue(temperature);
    }
}

