/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.core.config.Config;
import forestry.core.genetics.ItemGE;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.utils.EntityUtil;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.lepidopterology.genetics.ButterflyGenome;
import forestry.plugins.PluginLepidopterology;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemButterflyGE
extends ItemGE {
    private static final Random rand = new Random();
    private final EnumFlutterType type;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public ItemButterflyGE(EnumFlutterType type) {
        super(Tabs.tabLepidopterology);
        this.type = type;
    }

    @Override
    protected int getDefaultPrimaryColour() {
        return 0;
    }

    @Override
    protected int getDefaultSecondaryColour() {
        return 0;
    }

    @Override
    public IButterfly getIndividual(ItemStack itemstack) {
        return ButterflyManager.butterflyRoot.getMember(itemstack);
    }

    @Override
    protected IAlleleSpecies getSpecies(ItemStack itemStack) {
        return ButterflyGenome.getSpecies(itemStack);
    }

    public String func_77653_i(ItemStack itemstack) {
        if (itemstack.func_77978_p() == null) {
            return "???";
        }
        IButterfly butterfly = ButterflyManager.butterflyRoot.getMember(itemstack);
        if (butterfly == null) {
            return "???";
        }
        return butterfly.getDisplayName();
    }

    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        this.addCreativeItems(itemList, true);
    }

    public void addCreativeItems(List<ItemStack> itemList, boolean hideSecrets) {
        for (IIndividual iIndividual : ButterflyManager.butterflyRoot.getIndividualTemplates()) {
            if (hideSecrets && iIndividual.isSecret() && !Config.isDebug) continue;
            itemList.add(ButterflyManager.butterflyRoot.getMemberStack(iIndividual, this.type.ordinal()));
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (this.type != EnumFlutterType.BUTTERFLY) {
            return false;
        }
        if (entityItem.field_70170_p.field_72995_K || entityItem.field_70173_aa < 80) {
            return false;
        }
        if (rand.nextInt(24) != 0) {
            return false;
        }
        IButterfly butterfly = ButterflyManager.butterflyRoot.getMember(entityItem.func_92059_d());
        if (butterfly == null) {
            return false;
        }
        if (!butterfly.canTakeFlight(entityItem.field_70170_p, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v)) {
            return false;
        }
        if (entityItem.field_70170_p.func_72907_a(EntityButterfly.class) > PluginLepidopterology.entityConstraint) {
            return false;
        }
        if (EntityUtil.spawnEntity(entityItem.field_70170_p, new EntityButterfly(entityItem.field_70170_p, butterfly), entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v) != null) {
            if (entityItem.func_92059_d().field_77994_a > 1) {
                --entityItem.func_92059_d().field_77994_a;
            } else {
                entityItem.func_70106_y();
            }
            return true;
        }
        return false;
    }

    @Override
    public int func_82790_a(ItemStack itemstack, int renderPass) {
        if (!itemstack.func_77942_o()) {
            return super.func_82790_a(itemstack, renderPass);
        }
        return this.getColourFromSpecies(AlleleManager.alleleRegistry.getIndividual(itemstack).getGenome().getPrimary(), renderPass);
    }

    @Override
    public int getColourFromSpecies(IAlleleSpecies species, int renderPass) {
        if (species != null) {
            return species.getIconColour(renderPass);
        }
        return 0xFFFFFF;
    }

    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.icons = new IIcon[2];
        switch (this.type) {
            case CATERPILLAR: {
                this.icons[0] = TextureManager.registerTex(register, "caterpillar.body");
                this.icons[1] = TextureManager.registerTex(register, "caterpillar.body2");
                break;
            }
            default: {
                this.icons[0] = TextureManager.registerTex(register, "liquids/jar.contents");
                this.icons[1] = TextureManager.registerTex(register, "liquids/jar.bottle");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int i, int j) {
        if (j > 0) {
            return this.icons[1];
        }
        return this.icons[0];
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int par7, float facingX, float facingY, float facingZ) {
        if (world.field_72995_K) {
            return false;
        }
        IButterfly flutter = ButterflyManager.butterflyRoot.getMember(itemstack);
        if (flutter == null) {
            return false;
        }
        if (this.type == EnumFlutterType.CATERPILLAR) {
            TileEntity target = world.func_147438_o(x, y, z);
            if (!(target instanceof IButterflyNursery)) {
                return false;
            }
            IButterflyNursery pollinatable = (IButterflyNursery)target;
            if (!pollinatable.canNurse(flutter)) {
                return false;
            }
            pollinatable.setCaterpillar(flutter);
            Proxies.common.sendFXSignal(PacketFXSignal.VisualFXType.BLOCK_DESTROY, PacketFXSignal.SoundFXType.LEAF, world, x, y, z, world.func_147439_a(x, y, z), 0);
            if (!player.field_71075_bZ.field_75098_d) {
                --itemstack.field_77994_a;
            }
            return true;
        }
        return false;
    }
}

