/*
 * Decompiled with CFR 0.152.
 */
package forestry.shade.javacheck.report;

import forestry.shade.javacheck.report.OutdatedJavaException;
import java.awt.Desktop;
import java.io.File;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;

public final class JavaCheckerReporter {
    public static void run(JavaVersion minVersion) {
        if (minVersion == null || !SystemUtils.isJavaVersionAtLeast((JavaVersion)minVersion)) {
            if (minVersion == null) {
                minVersion = JavaVersion.JAVA_1_8;
            }
            try {
                Class relaunchLog = JavaCheckerReporter.findRelaunchLog();
                if (relaunchLog != null) {
                    relaunchLog.getMethod("severe", String.class, Object[].class).invoke(null, JavaCheckerReporter.getConsoleReport(minVersion), new Object[0]);
                }
            }
            catch (Throwable relaunchLog) {
                // empty catch block
            }
            String style = "font-family:Dialog;font-size:12;font-weight:bold";
            JEditorPane pane = new JEditorPane("text/html", "<html><body style='" + style + "'>" + JavaCheckerReporter.getWindowReport(minVersion) + "</body></html>");
            pane.setBackground(new JLabel().getBackground());
            pane.setEditable(false);
            pane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        try {
                            if (Desktop.isDesktopSupported()) {
                                Desktop.getDesktop().browse(e.getURL().toURI());
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            });
            JOptionPane.showMessageDialog(null, pane, "Outdated Java", 0);
            throw new OutdatedJavaException();
        }
        try {
            Class cmm = JavaCheckerReporter.findCoreModManager();
            List coremods = (List)cmm.getMethod("getLoadedCoremods", new Class[0]).invoke(null, new Object[0]);
            List reparsed = (List)cmm.getMethod("getReparseableCoremods", new Class[0]).invoke(null, new Object[0]);
            String myFile = new File(JavaCheckerReporter.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getName();
            coremods.remove(myFile);
            reparsed.add(myFile);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static String getConsoleReport(JavaVersion minVersion) {
        return new StringBuilder(242).append("\n").append("\n!! DO NOT REPORT !!\n\n").append("One of the mods requires Java " + minVersion.toString() + " or newer, you are using ").append(SystemUtils.JAVA_VERSION).append(".\n").append("Visit https://java.com/download/ for the latest version.\n").append("Please, uninstall the old version first to prevent further issues.").append("\n\n!! DO NOT REPORT !!\n").toString();
    }

    private static String getWindowReport(JavaVersion minVersion) {
        return new StringBuilder(230).append("One of the mods requires Java " + minVersion.toString() + " or newer, you are using ").append(SystemUtils.JAVA_VERSION).append(".<br>").append("Visit <a href=\"https://java.com/download/\"><span style=\"color:blue\">https://java.com/download/</span></a> for the latest version.<br>").append("Please, uninstall the old version first to prevent further issues.").toString();
    }

    private static Class findRelaunchLog() throws Throwable {
        try {
            return Class.forName("cpw.mods.fml.relauncher.FMLRelaunchLog");
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Class.forName("net.minecraftforge.fml.relauncher.FMLRelaunchLog");
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return null;
            }
        }
    }

    private static Class findCoreModManager() throws Throwable {
        try {
            return Class.forName("cpw.mods.fml.relauncher.CoreModManager");
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Class.forName("net.minecraftforge.fml.relauncher.CoreModManager");
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return null;
            }
        }
    }
}

