/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.launchertray;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cpw.mods.fml.common.ProgressManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.creeperhost.launchertray.HookLoader;
import net.creeperhost.launchertray.OurFunctions;
import net.creeperhost.launchertray.WebUtils;
import net.minecraft.launchwrapper.Launch;

public class LauncherTray {
    static boolean disabled;
    static String instanceUUID;
    private static Socket server;
    private static OutputStream streamWrite;
    private static InputStream streamRead;
    private static Gson gson;
    private static long lastMessageTime;
    private static boolean obfuscatedInit;
    private static boolean deobfuscatedCache;

    static void connect(int port) {
        CompletableFuture.runAsync(() -> {
            try {
                server = new Socket(InetAddress.getLocalHost(), port);
                streamRead = server.getInputStream();
                streamWrite = server.getOutputStream();
                while (server.isConnected() && !server.isClosed()) {
                    byte[] input = new byte[512];
                    int read = streamRead.read(input);
                    if (read <= 0) continue;
                    JsonParser parser = new JsonParser();
                    try {
                        JsonElement parse = parser.parse(new String(input, 0, read));
                        if (!parse.isJsonObject()) continue;
                        JsonObject asJsonObject = parse.getAsJsonObject();
                        String message = asJsonObject.get("message").getAsString();
                        if (message.equals("show")) {
                            OurFunctions.showWindow();
                            continue;
                        }
                        if (!message.equals("yeet")) continue;
                        OurFunctions.kill();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    public static String getInstanceID() {
        File file = new File("");
        String ID = file.getAbsoluteFile().getName();
        Pattern pattern = Pattern.compile("(mc-.{13})");
        Matcher matcher = pattern.matcher(ID);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "";
    }

    private static JsonElement toJson(Object obj) {
        if (gson == null) {
            gson = new Gson();
        }
        return gson.toJsonTree(obj);
    }

    static void sendInit() {
        LauncherTray.sendText("init");
    }

    static void sendDone() {
        LauncherTray.sendText("done");
    }

    private static void sendText(String text) {
        JsonObject jsonObject = new JsonObject();
        if (!LauncherTray.getInstanceID().isEmpty()) {
            jsonObject.addProperty("instance", HookLoader.instanceID);
        }
        jsonObject.addProperty("type", "message");
        jsonObject.addProperty("message", text);
        LauncherTray.sendJsonObject(jsonObject, true);
    }

    static void sendProgress(Iterator<ProgressManager.ProgressBar> progressBarIterator) {
        ArrayList list = new ArrayList();
        progressBarIterator.forEachRemaining(list::add);
        JsonObject jsonObject = new JsonObject();
        if (!LauncherTray.getInstanceID().isEmpty()) {
            jsonObject.addProperty("instance", HookLoader.instanceID);
        }
        jsonObject.addProperty("type", "progress");
        JsonObject data = new JsonObject();
        data.add("bars", LauncherTray.toJson(list));
        jsonObject.add("data", (JsonElement)data);
        LauncherTray.sendJsonObject(jsonObject, false);
    }

    private static void sendJsonObject(JsonObject jsonObject, boolean force) {
        if (System.currentTimeMillis() > lastMessageTime + 300L || force) {
            lastMessageTime = System.currentTimeMillis();
            System.out.println(jsonObject.toString());
            if (!LauncherTray.getInstanceID().isEmpty()) {
                CompletableFuture.runAsync(() -> WebUtils.putWebResponse("https://api.creeper.host/callbacks/minecraft/loading.php", LauncherTray.toJson(jsonObject).toString(), true, false));
            } else {
                if (server == null || server.isClosed() || !server.isConnected()) {
                    return;
                }
                jsonObject.addProperty("instance", instanceUUID);
                try {
                    streamWrite.write((LauncherTray.toJson(jsonObject).toString() + "\n").getBytes());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    static String getName(String deobfName, String obfName) {
        if (!obfuscatedInit) {
            deobfuscatedCache = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
            obfuscatedInit = true;
        }
        return deobfuscatedCache ? deobfName : obfName;
    }

    static {
        lastMessageTime = 0L;
        obfuscatedInit = false;
        deobfuscatedCache = false;
    }
}

