/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.vanilla;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import openperipheral.api.helpers.ItemStackMetaProviderSimple;

public class ItemPotionMetaProvider
extends ItemStackMetaProviderSimple<ItemPotion> {
    public String getKey() {
        return "potion";
    }

    public Object getMeta(ItemPotion target, ItemStack stack) {
        HashMap results = Maps.newHashMap();
        results.put("splash", ItemPotion.func_77831_g((int)stack.func_77960_j()));
        ArrayList effectsInfo = Lists.newArrayList();
        List effects = target.func_77832_l(stack);
        if (effects != null) {
            for (PotionEffect effect : effects) {
                HashMap entry = Maps.newHashMap();
                entry.put("duration", effect.func_76459_b() / 20);
                entry.put("amplifier", effect.func_76458_c());
                entry.put("effect", ItemPotionMetaProvider.getPotionInfo(effect.func_76456_a()));
                effectsInfo.add(entry);
            }
        }
        results.put("effects", effectsInfo);
        return results;
    }

    public static Map<String, Object> getPotionInfo(int potionId) {
        if (potionId < 0 || potionId >= Potion.field_76425_a.length) {
            return null;
        }
        HashMap result = Maps.newHashMap();
        Potion potion = Potion.field_76425_a[potionId];
        result.put("name", potion.func_76393_a());
        result.put("instant", potion.func_76403_b());
        result.put("color", potion.func_76401_j());
        return result;
    }
}

