/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.log4jpatcher;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.ProtectionDomain;
import net.creeperhost.log4jpatcher.Main;
import net.creeperhost.repack.org.objectweb.asm.ClassReader;
import net.creeperhost.repack.org.objectweb.asm.ClassWriter;
import net.creeperhost.repack.org.objectweb.asm.tree.ClassNode;
import net.creeperhost.repack.org.objectweb.asm.tree.FieldNode;
import net.creeperhost.repack.org.objectweb.asm.tree.MethodNode;

public abstract class Transformer
implements ClassFileTransformer {
    protected static PrintStream logger = System.out;

    @Override
    public final byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] bytes) throws IllegalClassFormatException {
        try {
            return this.transform(className, bytes);
        }
        catch (Throwable ex) {
            return bytes;
        }
    }

    public abstract byte[] transform(String var1, byte[] var2);

    protected ClassNode parseClassNode(byte[] bytes) {
        return this.parseClassNode(bytes, 0);
    }

    protected ClassNode parseClassNode(byte[] bytes, int flags) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode cNode = new ClassNode();
        reader.accept(cNode, flags);
        return cNode;
    }

    protected byte[] writeClass(ClassNode cNode) {
        return this.writeClass(cNode, 0);
    }

    protected byte[] writeClass(ClassNode cNode, int flags) {
        ClassWriter writer = new ClassWriter(flags);
        cNode.accept(writer);
        byte[] bytes = writer.toByteArray();
        if (Main.DEBUG) {
            try {
                Path path = Paths.get("asm/log4jpatcher/" + cNode.name + ".class", new String[0]);
                if (!Files.exists(path.getParent(), new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                }
                Files.write(path, bytes, new OpenOption[0]);
            }
            catch (IOException e) {
                logger.println("[Log4jPatcher] [WARN] Failed to write file.");
                e.printStackTrace(logger);
            }
        }
        return bytes;
    }

    protected MethodNode findMethod(ClassNode cNode, String name, String desc) {
        for (MethodNode method : cNode.methods) {
            if (!method.name.equals(name) || !method.desc.equals(desc) && !desc.equals("*")) continue;
            return method;
        }
        return null;
    }

    protected FieldNode findField(ClassNode cNode, String name, String desc) {
        for (FieldNode field : cNode.fields) {
            if (!field.name.equals(name) || !field.desc.equals(desc) && !desc.equals("*")) continue;
            return field;
        }
        return null;
    }
}

