/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.layer;

import biomesoplenty.common.configuration.BOPConfigurationBiomeGen;
import biomesoplenty.common.core.BOPBiomes;
import biomesoplenty.common.world.BOPBiomeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerBiome;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.BiomeManager;

public class GenLayerBiomeBOP
extends GenLayerBiome {
    public final List<BiomeManager.BiomeEntry>[] biomeLists = new ArrayList[]{new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList()};
    private final int[] totalWeights = new int[this.biomeLists.length];

    public GenLayerBiomeBOP(long seed, GenLayer parentLayer, WorldType worldType) {
        super(seed, parentLayer, worldType);
        this.biomeLists[0].addAll(BOPBiomeManager.overworldBiomes[0]);
        this.biomeLists[1].addAll(BOPBiomeManager.overworldBiomes[1]);
        this.biomeLists[2].addAll(BOPBiomeManager.overworldBiomes[2]);
        this.biomeLists[3].addAll(BOPBiomeManager.overworldBiomes[3]);
        if (BiomeManager.getBiomes((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT) != null) {
            this.biomeLists[0].addAll((Collection<BiomeManager.BiomeEntry>)BiomeManager.getBiomes((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT));
        }
        if (BiomeManager.getBiomes((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM) != null) {
            this.biomeLists[1].addAll((Collection<BiomeManager.BiomeEntry>)BiomeManager.getBiomes((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM));
        }
        if (BiomeManager.getBiomes((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL) != null) {
            this.biomeLists[2].addAll((Collection<BiomeManager.BiomeEntry>)BiomeManager.getBiomes((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL));
        }
        if (BiomeManager.getBiomes((BiomeManager.BiomeType)BiomeManager.BiomeType.ICY) != null) {
            this.biomeLists[3].addAll((Collection<BiomeManager.BiomeEntry>)BiomeManager.getBiomes((BiomeManager.BiomeType)BiomeManager.BiomeType.ICY));
        }
        this.biomeLists[0].add(new BiomeManager.BiomeEntry(BiomeGenBase.field_76769_d, 30));
        this.biomeLists[0].add(new BiomeManager.BiomeEntry(BiomeGenBase.field_150588_X, 20));
        this.biomeLists[0].add(new BiomeManager.BiomeEntry(BiomeGenBase.field_76772_c, 10));
        for (int i = 0; i < this.biomeLists.length; ++i) {
            List<BiomeManager.BiomeEntry> currentBiomeList = this.biomeLists[i];
            if (currentBiomeList.isEmpty()) {
                currentBiomeList.addAll(this.createMixedList());
            }
            this.totalWeights[i] = WeightedRandom.func_76272_a(currentBiomeList);
        }
    }

    public int[] func_75904_a(int x, int z, int width, int length) {
        int[] inputBiomeIDs = this.field_75909_a.func_75904_a(x, z, width, length);
        int[] outputBiomeIDs = IntCache.func_76445_a((int)(width * length));
        for (int i1 = 0; i1 < length; ++i1) {
            for (int j1 = 0; j1 < width; ++j1) {
                this.func_75903_a(j1 + x, i1 + z);
                int currentBiomeID = inputBiomeIDs[j1 + i1 * width];
                int l1 = (currentBiomeID & 0xF00) >> 8;
                currentBiomeID &= 0xFFFFF0FF;
                if (BOPBiomes.onlyBiome != null) {
                    outputBiomeIDs[j1 + i1 * width] = BOPBiomes.onlyBiome.field_76756_M;
                    continue;
                }
                if (this.isBiomeOceanicAndEnabled(currentBiomeID)) {
                    outputBiomeIDs[j1 + i1 * width] = currentBiomeID;
                    continue;
                }
                if (currentBiomeID == BiomeGenBase.field_76789_p.field_76756_M && BOPConfigurationBiomeGen.mushroomIslandGen) {
                    outputBiomeIDs[j1 + i1 * width] = currentBiomeID;
                    continue;
                }
                if (currentBiomeID == 1) {
                    if (l1 > 0) {
                        if (this.func_75902_a(3) == 0 && BOPConfigurationBiomeGen.mesaPlateauGen) {
                            outputBiomeIDs[j1 + i1 * width] = BiomeGenBase.field_150608_ab.field_76756_M;
                            continue;
                        }
                        if (BOPConfigurationBiomeGen.mesaPlateauFGen) {
                            outputBiomeIDs[j1 + i1 * width] = BiomeGenBase.field_150607_aa.field_76756_M;
                            continue;
                        }
                        outputBiomeIDs[j1 + i1 * width] = this.getBiomeIdFromList(0);
                        continue;
                    }
                    outputBiomeIDs[j1 + i1 * width] = this.getBiomeIdFromList(0);
                    continue;
                }
                if (currentBiomeID == 2) {
                    if (l1 > 0 && BOPConfigurationBiomeGen.jungleGen) {
                        outputBiomeIDs[j1 + i1 * width] = BiomeGenBase.field_76782_w.field_76756_M;
                        continue;
                    }
                    outputBiomeIDs[j1 + i1 * width] = this.getBiomeIdFromList(1);
                    continue;
                }
                if (currentBiomeID == 3) {
                    if (l1 > 0 && BOPConfigurationBiomeGen.megaTaigaGen) {
                        outputBiomeIDs[j1 + i1 * width] = BiomeGenBase.field_150578_U.field_76756_M;
                        continue;
                    }
                    outputBiomeIDs[j1 + i1 * width] = this.getBiomeIdFromList(2);
                    continue;
                }
                outputBiomeIDs[j1 + i1 * width] = currentBiomeID == 4 ? this.getBiomeIdFromList(3) : this.getBiomeIdFromList(this.getRandomValidList());
            }
        }
        return outputBiomeIDs;
    }

    private int getRandomValidList() {
        ArrayList<Integer> validLists = new ArrayList<Integer>();
        for (int i = 0; i < this.biomeLists.length; ++i) {
            validLists.add(i);
        }
        int list = -1;
        while (list == -1) {
            int validListCount = validLists.size();
            if (validListCount > 0) {
                int randList = (Integer)validLists.get(this.func_75902_a(validListCount));
                List<BiomeManager.BiomeEntry> currentList = this.biomeLists[randList];
                if (currentList != null && !currentList.isEmpty()) {
                    list = randList;
                    continue;
                }
                validLists.remove((Object)randList);
                continue;
            }
            throw new RuntimeException("No biomes are enabled!");
        }
        return list;
    }

    private int getBiomeIdFromList(int listId) {
        List<BiomeManager.BiomeEntry> currentBiomeList = this.biomeLists[listId];
        if (!currentBiomeList.isEmpty()) {
            int weight = this.func_75902_a(this.totalWeights[listId]);
            return ((BiomeManager.BiomeEntry)WeightedRandom.getItem(this.biomeLists[listId], (int)weight)).biome.field_76756_M;
        }
        throw new RuntimeException("No biomes are enabled!");
    }

    private List<BiomeManager.BiomeEntry> createMixedList() {
        ArrayList<BiomeManager.BiomeEntry> combinedList = new ArrayList<BiomeManager.BiomeEntry>();
        ArrayList<BiomeManager.BiomeEntry> mixedList = new ArrayList<BiomeManager.BiomeEntry>();
        int maxSize = 0;
        for (List<BiomeManager.BiomeEntry> biomeList : this.biomeLists) {
            if (biomeList == null || biomeList.isEmpty()) continue;
            combinedList.addAll(biomeList);
            if (biomeList.size() <= maxSize) continue;
            maxSize = biomeList.size();
        }
        while (mixedList.size() < maxSize) {
            mixedList.add((BiomeManager.BiomeEntry)WeightedRandom.getItem(combinedList, (int)this.func_75902_a(WeightedRandom.func_76272_a(combinedList))));
        }
        return mixedList;
    }

    private boolean isBiomeOceanicAndEnabled(int biomeId) {
        return biomeId == BiomeGenBase.field_76771_b.field_76756_M && BOPConfigurationBiomeGen.oceanGen || biomeId == BiomeGenBase.field_150575_M.field_76756_M && BOPConfigurationBiomeGen.deepOceanGen || biomeId == BiomeGenBase.field_76776_l.field_76756_M && BOPConfigurationBiomeGen.frozenOceanGen;
    }
}

