/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import thaumicenergistics.api.IThEConfig;

class ConfigurationHandler
implements IThEConfig {
    private static ConfigurationHandler INSTANCE;
    private static final String CATEGORY_CRAFTING = "crafting";
    private static final String CATEGORY_CLIENT = "client";
    private static final String CATEGORY_INTEGRATION = "integration";
    private static final int DFT_CONVERSION_EXPONENT = 7;
    private static final boolean DFT_CRAFT_ARCANE_ASSEMBLER = true;
    private static final boolean DFT_CRAFT_ARCANE_CRAFTING_TERM = true;
    private static final boolean DFT_CRAFT_DISTILLATION_PATTERN_ENCODER = true;
    private static final boolean DFT_CRAFT_ESSENTIA_CELLS = true;
    private static final boolean DFT_CRAFT_ESSENTIA_PROVIDER = true;
    private static final boolean DFT_CRAFT_ESSENTIA_VIBRATION_CHAMBER = true;
    private static final boolean DFT_CRAFT_GOLEM_BACKPACK = true;
    private static final boolean DFT_CRAFT_INFUSION_PROVIDER = true;
    private static final boolean DFT_CRAFT_IO_BUSES = true;
    private static final boolean DFT_CRAFT_VIS_RELAY_INTERFACE = true;
    private static final boolean DFT_CRAFT_WIRELESS_ESSENTIA_TERM = true;
    private static final boolean DFT_DISABLE_GEARBOX = false;
    private static final boolean DFT_ENABLE_QUARTZ_DUPE = true;
    private static final boolean DFT_ENABLE_WRENCH_FOCUS = true;
    private static final boolean DFT_EXTRACELLS_BLIST = true;
    private static final boolean DFT_FORCE_TC_FACADES = true;
    private Configuration configSettings;
    private int conversionMultiplier = (int)Math.pow(2.0, 7.0);
    private boolean craft_Arcane_Assembler = true;
    private boolean craft_Arcane_Crafting_Term = true;
    private boolean craft_Distillation_Pattern_Encoder = true;
    private boolean craft_Essentia_Cells = true;
    private boolean craft_Essentia_Provider = true;
    private boolean craft_Essentia_Vibration_Chamber = true;
    private boolean craft_GolemBackpack = true;
    private boolean craft_Infusion_Provider = true;
    private boolean craft_IO_Buses = true;
    private boolean craft_Vis_Relay_Interface = true;
    private boolean craft_Wireless_Essentia_Term = true;
    private boolean disable_Gearbox = false;
    private boolean enable_Quartz_Dupe = true;
    private boolean enable_Wrench_Focus = true;
    private boolean extracells_Blist = true;
    private boolean force_TC_Facades = true;

    private ConfigurationHandler(Configuration config) {
        this.configSettings = config;
        this.synchronizeConfigFile();
    }

    public static IThEConfig loadAndSyncConfigFile(File configFile) {
        if (INSTANCE == null) {
            INSTANCE = new ConfigurationHandler(new Configuration(configFile));
        }
        return INSTANCE;
    }

    private void synchronizeConfigFile() {
        int fluidPow = this.configSettings.getInt("Essentia Fluid Ratio Exponent", "general", 7, 1, 11, "Controls the conversion ratio of essentia/fluid. 1 essentia is converted to (2^this) milibuckets of fluid. Please be aware that this value effects how much fluid is transferred through the AE system, which also effects transfer speed and power consumption. Values above 11 make it impossible to use fluid transfer devices such as the ME IO Port, or anything from EC2.");
        this.conversionMultiplier = (int)Math.pow(2.0, Math.min(fluidPow, 11));
        this.craft_Arcane_Assembler = this.configSettings.getBoolean("Arcane Assembler", CATEGORY_CRAFTING, true, "Controls if the Arcane Assembler can be crafted.");
        this.craft_Arcane_Crafting_Term = this.configSettings.getBoolean("Arcane Crafting Terminal", CATEGORY_CRAFTING, true, "Controls if the Arcane Crafting Terminal can be crafted.");
        this.craft_Distillation_Pattern_Encoder = this.configSettings.getBoolean("Distillation Pattern Encoder.", CATEGORY_CRAFTING, true, "Controls if the Distillation Pattern Encoder can be crafted.");
        this.craft_Essentia_Cells = this.configSettings.getBoolean("Essentia Cells", CATEGORY_CRAFTING, true, "Controls if Essentia Cells and Components can be crafted.");
        this.craft_Essentia_Provider = this.configSettings.getBoolean("Essentia Provider", CATEGORY_CRAFTING, true, "Controls if the Essentia Provider can be crafted.");
        this.craft_Essentia_Vibration_Chamber = this.configSettings.getBoolean("Essentia Vibration Chamber", CATEGORY_CRAFTING, true, "Controlls if the Essentia Vibration Chamber can be crafted.");
        this.craft_GolemBackpack = this.configSettings.getBoolean("Golem Wifi Backpack", CATEGORY_CRAFTING, true, "Controls if the Golem Wifi Backpack can be crafted.");
        this.craft_Infusion_Provider = this.configSettings.getBoolean("Infusion Provider", CATEGORY_CRAFTING, true, "Controls if the Infusion Provider can be crafted.");
        this.craft_IO_Buses = this.configSettings.getBoolean("IO Buses", CATEGORY_CRAFTING, true, "Controls if the import and export buses can be crafted.");
        this.craft_Vis_Relay_Interface = this.configSettings.getBoolean("Vis Relay Interface", CATEGORY_CRAFTING, true, "Controls if the Vis Relay Interface can be crafted.");
        this.craft_Wireless_Essentia_Term = this.configSettings.getBoolean("Allow Crafting Wireless Essentia Terminal", CATEGORY_CRAFTING, true, "Controls if the Wireless Essentia Terminal can be crafted.");
        this.enable_Quartz_Dupe = this.configSettings.getBoolean("Certus Quartz Duplication", CATEGORY_CRAFTING, true, "Controls if Certus Quartz can be duplicated in the crucible.");
        this.enable_Wrench_Focus = this.configSettings.getBoolean("Wrench Focus", CATEGORY_CRAFTING, true, "Controls if the Wrench Focus is enabled and craftable.");
        this.force_TC_Facades = this.configSettings.getBoolean("Force TC Facades", CATEGORY_CRAFTING, true, "When enabled, overwrites the AE2 facade settings for some Thaumcraft blocks, allowing their facades to be crafted.");
        this.disable_Gearbox = this.configSettings.getBoolean("Disable Gearbox Model", CATEGORY_CLIENT, false, "The iron and thaumium gearboxes will be rendered as a standard block.");
        this.extracells_Blist = this.configSettings.getBoolean("ExtraCells Blacklist", CATEGORY_INTEGRATION, true, "Prevents extra cells from interacting with essentia gas");
        if (this.configSettings.hasChanged()) {
            this.configSettings.save();
        }
    }

    @Override
    public boolean blacklistEssentiaFluidInExtraCells() {
        return this.extracells_Blist;
    }

    @Override
    public int conversionMultiplier() {
        return this.conversionMultiplier;
    }

    @Override
    public boolean craftArcaneAssembler() {
        return this.craft_Arcane_Assembler;
    }

    @Override
    public boolean craftArcaneCraftingTerminal() {
        return this.craft_Arcane_Crafting_Term;
    }

    @Override
    public boolean craftDistillationPatternEncoder() {
        return this.craft_Distillation_Pattern_Encoder;
    }

    @Override
    public boolean craftEssentiaCells() {
        return this.craft_Essentia_Cells;
    }

    @Override
    public boolean craftEssentiaProvider() {
        return this.craft_Essentia_Provider;
    }

    @Override
    public boolean craftEssentiaVibrationChamber() {
        return this.craft_Essentia_Vibration_Chamber;
    }

    @Override
    public boolean craftGolemWifiBackpack() {
        return this.craft_GolemBackpack;
    }

    @Override
    public boolean craftInfusionProvider() {
        return this.craft_Infusion_Provider;
    }

    @Override
    public boolean craftIOBuses() {
        return this.craft_IO_Buses;
    }

    @Override
    public boolean craftVisRelayInterface() {
        return this.craft_Vis_Relay_Interface;
    }

    @Override
    public boolean craftWirelessEssentiaTerminal() {
        return this.craft_Wireless_Essentia_Term;
    }

    @Override
    public boolean disableGearboxModel() {
        return this.disable_Gearbox;
    }

    @Override
    public boolean enableCertusQuartzDupe() {
        return this.enable_Quartz_Dupe;
    }

    @Override
    public boolean enableWrenchFocus() {
        return this.enable_Wrench_Focus;
    }

    @Override
    public boolean forceTCFacades() {
        return this.force_TC_Facades;
    }
}

