/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.net.helpers;

import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorRedNetPort;
import erogenousbeef.core.common.CoordTriplet;
import io.netty.buffer.ByteBuf;

public class RedNetChange {
    int channelID;
    TileEntityReactorRedNetPort.CircuitType circuitType;
    boolean pulseOrToggle;
    CoordTriplet coord;

    public RedNetChange(int channelID, TileEntityReactorRedNetPort.CircuitType circuitType, boolean pulseOrToggle, CoordTriplet coord) {
        this.channelID = channelID;
        this.circuitType = circuitType;
        this.pulseOrToggle = pulseOrToggle;
        this.coord = coord;
    }

    public static RedNetChange fromBytes(ByteBuf buf) {
        boolean coordNull;
        int channelID = buf.readInt();
        TileEntityReactorRedNetPort.CircuitType type = TileEntityReactorRedNetPort.CircuitType.s_Types[buf.readInt()];
        boolean pulseOrToggle = false;
        if (TileEntityReactorRedNetPort.CircuitType.canBeToggledBetweenPulseAndNormal(type)) {
            pulseOrToggle = buf.readBoolean();
        }
        CoordTriplet coord = null;
        if (TileEntityReactorRedNetPort.CircuitType.hasCoordinate(type) && !(coordNull = buf.readBoolean())) {
            coord = new CoordTriplet(buf.readInt(), buf.readInt(), buf.readInt());
        }
        return new RedNetChange(channelID, type, pulseOrToggle, coord);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.channelID);
        buf.writeInt(this.circuitType.ordinal());
        if (TileEntityReactorRedNetPort.CircuitType.canBeToggledBetweenPulseAndNormal(this.circuitType)) {
            buf.writeBoolean(this.pulseOrToggle);
        }
        if (TileEntityReactorRedNetPort.CircuitType.hasCoordinate(this.circuitType)) {
            buf.writeBoolean(this.coord == null);
            if (this.coord != null) {
                buf.writeInt(this.coord.x);
                buf.writeInt(this.coord.y);
                buf.writeInt(this.coord.z);
            }
        }
    }

    public int getChannel() {
        return this.channelID;
    }

    public TileEntityReactorRedNetPort.CircuitType getType() {
        return this.circuitType;
    }

    public CoordTriplet getCoord() {
        return this.coord;
    }

    public boolean getPulseOrToggle() {
        return this.pulseOrToggle;
    }
}

