/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.net.message.base;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import erogenousbeef.bigreactors.common.BRLog;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPartBase;
import erogenousbeef.bigreactors.net.message.base.WorldMessageServer;
import erogenousbeef.core.common.CoordTriplet;
import net.minecraft.tileentity.TileEntity;

public abstract class ReactorMessageServer
extends WorldMessageServer {
    MultiblockReactor reactor;

    protected ReactorMessageServer() {
        this.reactor = null;
    }

    protected ReactorMessageServer(MultiblockReactor reactor, CoordTriplet referenceCoord) {
        super(referenceCoord.x, referenceCoord.y, referenceCoord.z);
        this.reactor = reactor;
    }

    protected ReactorMessageServer(MultiblockReactor reactor) {
        this(reactor, reactor.getReferenceCoord());
    }

    public static abstract class Handler<M extends ReactorMessageServer>
    extends WorldMessageServer.Handler<M> {
        protected abstract IMessage handleMessage(M var1, MessageContext var2, MultiblockReactor var3);

        @Override
        protected IMessage handleMessage(M message, MessageContext ctx, TileEntity te) {
            if (te instanceof TileEntityReactorPartBase) {
                MultiblockReactor reactor = ((TileEntityReactorPartBase)te).getReactorController();
                if (reactor != null) {
                    return this.handleMessage(message, ctx, reactor);
                }
                BRLog.error("Received ReactorMessageServer for a reactor part @ %d, %d, %d which has no attached reactor", te.field_145851_c, te.field_145848_d, te.field_145849_e);
            } else {
                BRLog.error("Received ReactorMessageServer for a non-reactor-part block @ %d, %d, %d", ((ReactorMessageServer)message).x, ((ReactorMessageServer)message).y, ((ReactorMessageServer)message).z);
            }
            return null;
        }
    }
}

