/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.net.message.base;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import erogenousbeef.bigreactors.common.BRLog;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class WorldMessage
implements IMessage {
    protected int x;
    protected int y;
    protected int z;

    protected WorldMessage() {
    }

    protected WorldMessage(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public static abstract class Handler<M extends WorldMessage>
    implements IMessageHandler<M, IMessage> {
        protected abstract World getWorld(MessageContext var1);

        protected abstract IMessage handleMessage(M var1, MessageContext var2, TileEntity var3);

        public IMessage onMessage(WorldMessage message, MessageContext ctx) {
            World world = this.getWorld(ctx);
            if (world == null) {
                BRLog.fatal("Unable to resolve world from messagecontext for WorldMessage", new Object[0]);
                return null;
            }
            TileEntity te = world.func_147438_o(message.x, message.y, message.z);
            if (te == null) {
                BRLog.error("Unable to find tile entity for WorldMessage at %d, %d, %d", message.x, message.y, message.z);
                return null;
            }
            return this.handleMessage(message, ctx, te);
        }
    }
}

