/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.forestry.pipes.network;

import buildcraft.core.lib.network.PacketCoordinates;
import cpw.mods.fml.common.network.ByteBufUtils;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PacketGenomeFilterChange
extends PacketCoordinates {
    private int orientation;
    private int pattern;
    private int allele;
    private String species;

    public PacketGenomeFilterChange() {
    }

    public PacketGenomeFilterChange(TileEntity tile, ForgeDirection orientation, int pattern, int allele, IAllele species) {
        super(122, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        this.orientation = orientation.ordinal();
        this.pattern = pattern;
        this.allele = allele;
        this.species = species != null ? species.getUID() : "";
    }

    public void writeData(ByteBuf data) {
        super.writeData(data);
        data.writeShort(this.orientation);
        data.writeShort(this.pattern);
        data.writeShort(this.allele);
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.species);
    }

    public void readData(ByteBuf data) {
        super.readData(data);
        this.orientation = data.readShort();
        this.pattern = data.readShort();
        this.allele = data.readShort();
        this.species = ByteBufUtils.readUTF8String((ByteBuf)data);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getPattern() {
        return this.pattern;
    }

    public int getAllele() {
        return this.allele;
    }

    public IAllele getSpecies() {
        if (this.species.length() == 0) {
            return null;
        }
        return AlleleManager.alleleRegistry.getAllele(this.species);
    }
}

