/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses.drawable;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import openmods.geometry.Box2d;
import openmods.structured.StructureField;
import openperipheral.addons.glasses.drawable.Drawable;
import openperipheral.addons.glasses.drawable.DrawableType;
import openperipheral.addons.glasses.utils.RenderState;
import openperipheral.api.adapter.AdapterSourceName;
import openperipheral.api.adapter.Property;
import openperipheral.api.adapter.method.ScriptObject;
import org.lwjgl.opengl.GL11;

@ScriptObject
@AdapterSourceName(value="glasses_box")
public class SolidBox
extends Drawable {
    @Property
    @StructureField
    public float x;
    @Property
    @StructureField
    public float y;
    @Property
    @StructureField
    public float width;
    @Property
    @StructureField
    public float height;
    @Property
    @StructureField
    public int color;
    @Property
    @StructureField
    public float opacity;

    SolidBox() {
    }

    public SolidBox(float x, float y, float width, float height, int color, float opacity) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.color = color;
        this.opacity = opacity;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void drawContents(RenderState renderState, float partialTicks) {
        renderState.setupSolidRender();
        renderState.setColor(this.color, this.opacity);
        GL11.glBegin((int)7);
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)0.0f, (float)this.height);
        GL11.glVertex2f((float)this.width, (float)this.height);
        GL11.glVertex2f((float)this.width, (float)0.0f);
        GL11.glEnd();
    }

    @Override
    public DrawableType getTypeEnum() {
        return DrawableType.BOX;
    }

    @Override
    public boolean isVisible() {
        return this.opacity > 0.0f;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.setBoundingBox(Box2d.fromOriginAndSize((float)this.x, (float)this.y, (float)this.width, (float)this.height));
    }
}

