/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses.utils;

import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class RenderState {
    private final FloatBuffer colors = BufferUtils.createFloatBuffer((int)16);
    private boolean lighting;
    private boolean alphaTest;
    private boolean depthTest;
    private boolean texture;
    private boolean blend;
    private int blendSrc;
    private int blendDst;
    private float pointSize;
    private float lineWidth;
    private boolean cullFace;
    private int color;

    public void forceKnownState() {
        GL11.glDisable((int)2896);
        this.lighting = false;
        GL11.glDisable((int)3008);
        this.alphaTest = false;
        GL11.glDisable((int)3553);
        this.texture = false;
        GL11.glDisable((int)2929);
        this.depthTest = false;
        GL11.glEnable((int)3042);
        this.blend = true;
        this.blendDst = 771;
        this.blendSrc = 770;
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2884);
        this.cullFace = false;
        GL11.glPointSize((float)1.0f);
        this.pointSize = 1.0f;
        GL11.glLineWidth((float)1.0f);
        this.lineWidth = 1.0f;
    }

    public void readState() {
        this.lighting = GL11.glIsEnabled((int)2896);
        this.alphaTest = GL11.glIsEnabled((int)3008);
        this.texture = GL11.glIsEnabled((int)3553);
        this.depthTest = GL11.glIsEnabled((int)2929);
        this.blend = GL11.glIsEnabled((int)3042);
        this.blendSrc = GL11.glGetInteger((int)3041);
        this.blendDst = GL11.glGetInteger((int)3040);
        this.cullFace = GL11.glIsEnabled((int)2884);
        this.lineWidth = GL11.glGetFloat((int)2849);
        this.pointSize = GL11.glGetFloat((int)2833);
        GL11.glGetFloat((int)2816, (FloatBuffer)this.colors);
        float r = this.colors.get();
        float g = this.colors.get();
        float b = this.colors.get();
        float a = this.colors.get();
        this.color = (((int)(255.0f * r) & 0xFF) << 24) + (((int)(255.0f * g) & 0xFF) << 16) + (((int)(255.0f * b) & 0xFF) << 8) + (((int)(255.0f * a) & 0xFF) << 0);
        this.colors.clear();
    }

    public void setupCommonRender() {
        this.disableLight();
        this.disableAlphaTest();
        this.disableDepthTest();
        this.enableBlending();
        this.setBlendFunc(770, 771);
        this.disableCullFace();
    }

    public void setupSolidRender() {
        this.setupCommonRender();
        this.disableTexture();
    }

    public void setupTexturedRender() {
        this.setupCommonRender();
        this.enableTexture();
    }

    public void setColor(int rgb, float opacity) {
        byte scaledOpacity = (byte)(opacity * 255.0f);
        int newColor = rgb << 8 | scaledOpacity & 0xFF;
        if (newColor != this.color) {
            byte r = (byte)(rgb >> 16);
            byte g = (byte)(rgb >> 8);
            byte b = (byte)(rgb >> 0);
            GL11.glColor4ub((byte)r, (byte)g, (byte)b, (byte)scaledOpacity);
            this.color = newColor;
        }
    }

    public void setLineWidth(float lineWidth) {
        if (lineWidth != this.lineWidth) {
            GL11.glLineWidth((float)lineWidth);
            this.lineWidth = lineWidth;
        }
    }

    public void setPointSize(float pointSize) {
        if (pointSize != this.pointSize) {
            GL11.glPointSize((float)pointSize);
            this.pointSize = pointSize;
        }
    }

    public void enableBlending() {
        if (!this.blend) {
            GL11.glEnable((int)3042);
            this.blend = true;
        }
    }

    public void setBlendFunc(int src, int dst) {
        if (dst != this.blendDst || src != this.blendSrc) {
            GL11.glBlendFunc((int)src, (int)dst);
            this.blendDst = dst;
            this.blendSrc = src;
        }
    }

    public void disableBlending() {
        if (this.blend) {
            GL11.glDisable((int)3042);
            this.blend = false;
        }
    }

    public void enableDepthTest() {
        if (!this.depthTest) {
            GL11.glEnable((int)2929);
            this.depthTest = true;
        }
    }

    public void disableDepthTest() {
        if (this.depthTest) {
            GL11.glDisable((int)2929);
            this.depthTest = false;
        }
    }

    public void enableTexture() {
        if (!this.texture) {
            GL11.glEnable((int)3553);
            this.texture = true;
        }
    }

    public void disableTexture() {
        if (this.texture) {
            GL11.glDisable((int)3553);
            this.texture = false;
        }
    }

    public void enableAlphaTest() {
        if (!this.alphaTest) {
            GL11.glEnable((int)3008);
            this.alphaTest = true;
        }
    }

    public void disableAlphaTest() {
        if (this.alphaTest) {
            GL11.glDisable((int)3008);
            this.alphaTest = false;
        }
    }

    public void enableLight() {
        if (!this.lighting) {
            GL11.glEnable((int)2896);
            this.lighting = true;
        }
    }

    public void disableLight() {
        if (this.lighting) {
            GL11.glDisable((int)2896);
            this.lighting = false;
        }
    }

    public void enableCullFace() {
        if (!this.cullFace) {
            GL11.glEnable((int)2884);
            this.cullFace = true;
        }
    }

    public void disableCullFace() {
        if (this.cullFace) {
            GL11.glDisable((int)2884);
            this.cullFace = false;
        }
    }
}

