/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IClassification;
import java.util.ArrayList;
import magicbees.main.utils.LocalizationManager;

public enum BeeClassification implements IClassification
{
    VEILED("Veiled", "Velatapis"),
    ARCANE("Arcane", "Arcanapis"),
    SUPERNATURAL("Supernatural", "Occultapis"),
    SCHOLARLY("Scholarly", "Doctapis"),
    SKULKING("Skulking", "Malevolenapis"),
    MAGICAL("Magic", "Magicapis"),
    TIME("Time", "Tempestivapis"),
    SOUL("Soul", "Animapis"),
    ABOMINABLE("Abominable", "Detestabilapis"),
    EXTRINSIC("Extrinsic", "Extrarapis"),
    METALLIC("Metallic", "Metalliapis"),
    GEM("Gem", "Lapidapis"),
    TRANSMUTING("Transmuting", "Transmutapis"),
    THAUMIC("Thaumic", "Thaumiapis"),
    FLESHY("Fleshy", "Carnosapis"),
    ALCHEMICAL("Alchemical", "Alchimiapis"),
    ESSENTIAL("Essential", "Essentiapis"),
    THERMAL("Thermal", "Thermametallic"),
    ADORABLE("Adorable", "Amabilis"),
    BLOODY("Bloody", "Sanguis"),
    BOTANICAL("Botanical", "Botanica");

    private String uID;
    private String latin;
    private ArrayList<IAlleleSpecies> species;
    private IClassification parent;
    private IClassification.EnumClassLevel level;

    private BeeClassification(String name, String scientific) {
        this.uID = "classification." + name.toLowerCase();
        this.latin = scientific;
        this.level = IClassification.EnumClassLevel.GENUS;
        this.species = new ArrayList();
        this.parent = AlleleManager.alleleRegistry.getClassification("family.apidae");
        AlleleManager.alleleRegistry.registerClassification((IClassification)this);
    }

    public IClassification.EnumClassLevel getLevel() {
        return this.level;
    }

    public String getUID() {
        return this.uID;
    }

    public String getName() {
        return LocalizationManager.getLocalizedString(this.getUID());
    }

    public String getScientific() {
        return this.latin;
    }

    public String getDescription() {
        return LocalizationManager.getLocalizedString(this.getUID() + ".description");
    }

    public IClassification[] getMemberGroups() {
        return null;
    }

    public void addMemberGroup(IClassification group) {
    }

    public IAlleleSpecies[] getMemberSpecies() {
        return this.species.toArray(new IAlleleSpecies[this.species.size()]);
    }

    public void addMemberSpecies(IAlleleSpecies species) {
        if (!this.species.contains(species)) {
            this.species.add(species);
        }
    }

    public IClassification getParent() {
        return this.parent;
    }

    public void setParent(IClassification parent) {
        this.parent = parent;
    }
}

