/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.discovery.ASMDataTable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import openperipheral.api.architecture.FeatureGroup;
import openperipheral.api.architecture.IFeatureGroupManager;

public class FeatureGroupManager
implements IFeatureGroupManager {
    public static final FeatureGroupManager INSTANCE = new FeatureGroupManager();
    private final Map<String, FeatureGroupProperties> featureGroups = Maps.newHashMap();

    private FeatureGroupProperties getOrCreate(String featureGroup) {
        FeatureGroupProperties result = this.featureGroups.get(featureGroup);
        if (result == null) {
            result = new FeatureGroupProperties();
            this.featureGroups.put(featureGroup, result);
        }
        return result;
    }

    public void ensureExists(String featureGroup) {
        if (!this.featureGroups.containsKey(featureGroup)) {
            this.featureGroups.put(featureGroup, new FeatureGroupProperties());
        }
    }

    @Override
    public Set<String> knownFeatureGroups() {
        return Collections.unmodifiableSet(this.featureGroups.keySet());
    }

    @Override
    public void disable(String featureGroup, String architecture) {
        this.getOrCreate(featureGroup).disable(architecture);
    }

    @Override
    public void enable(String featureGroup, String architecture) {
        this.getOrCreate(featureGroup).enable(architecture);
    }

    @Override
    public boolean isEnabled(String featureGroup, String architecture) {
        return this.getOrCreate(featureGroup).isEnabled(architecture);
    }

    public FeatureGroupManager copy() {
        FeatureGroupManager result = new FeatureGroupManager();
        for (Map.Entry<String, FeatureGroupProperties> e : this.featureGroups.entrySet()) {
            result.featureGroups.put(e.getKey(), e.getValue().copy());
        }
        return result;
    }

    public String[] saveBlacklist() {
        TreeSet result = Sets.newTreeSet();
        for (Map.Entry<String, FeatureGroupProperties> e : this.featureGroups.entrySet()) {
            for (String architecture : e.getValue().blacklistedArchitectures) {
                result.add(e.getKey() + ":" + architecture);
            }
        }
        String[] tmp = new String[result.size()];
        return result.toArray(tmp);
    }

    public void loadBlacklist(String[] blacklist) {
        this.featureGroups.clear();
        if (blacklist == null) {
            return;
        }
        for (String entry : blacklist) {
            String[] split = entry.split(":");
            Preconditions.checkArgument((split.length == 2 ? 1 : 0) != 0, (String)"Malformed config entry: %s", (Object[])new Object[]{entry});
            String featureGroup = split[0];
            String architecture = split[1];
            this.disable(featureGroup, architecture);
        }
    }

    public void loadFeatureGroupsFromAnnotations(ASMDataTable asmData) {
        for (ASMDataTable.ASMData fgAnnotation : asmData.getAll(FeatureGroup.class.getName())) {
            List featureGroups = (List)fgAnnotation.getAnnotationInfo().get("value");
            for (String featureGroup : featureGroups) {
                this.ensureExists(featureGroup);
            }
        }
    }

    private static class FeatureGroupProperties {
        private final Set<String> blacklistedArchitectures = Sets.newHashSet();

        private FeatureGroupProperties() {
        }

        public void disable(String architecture) {
            this.blacklistedArchitectures.add(architecture);
        }

        public void enable(String architecture) {
            this.blacklistedArchitectures.remove(architecture);
        }

        public boolean isEnabled(String architecture) {
            return !this.blacklistedArchitectures.contains(architecture);
        }

        public FeatureGroupProperties copy() {
            FeatureGroupProperties result = new FeatureGroupProperties();
            result.blacklistedArchitectures.addAll(this.blacklistedArchitectures);
            return result;
        }
    }
}

