/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.converter.inbound;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Map;
import openperipheral.api.converter.IConverter;
import openperipheral.api.converter.IGenericInboundTypeConverter;
import openperipheral.converter.inbound.ContainerConverterHelper;

public class ConverterArrayInbound
implements IGenericInboundTypeConverter {
    private final ContainerConverterHelper<Object> converter;

    public ConverterArrayInbound(int offset) {
        this.converter = new ContainerConverterHelper<Object>(offset){

            @Override
            protected TypeToken<?> getComponentType(TypeToken<?> containerType) {
                return containerType.getComponentType();
            }

            @Override
            protected Object createEmptyContainer(TypeToken<?> componentType) {
                return Array.newInstance(componentType.getRawType(), 0);
            }

            @Override
            protected Object createNewContainer(TypeToken<?> componentType, int size) {
                return Array.newInstance(componentType.getRawType(), size);
            }

            @Override
            protected void setResult(Object result, int index, Object element) {
                Array.set(result, index, element);
            }
        };
    }

    @Override
    public Object toJava(IConverter registry, Object o, Type required) {
        TypeToken type;
        if (o instanceof Map && (type = TypeToken.of((Type)required)).isArray()) {
            return this.converter.convertToContainer(registry, o, type);
        }
        return null;
    }
}

