/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.converter.inbound;

import openperipheral.api.converter.IConverter;
import openperipheral.api.helpers.Index;
import openperipheral.converter.GenericInboundConverterAdapter;

public class ConverterNumberInbound
extends GenericInboundConverterAdapter {
    private final int offset;

    public ConverterNumberInbound(int offset) {
        this.offset = offset;
    }

    @Override
    public Object toJava(IConverter registry, Object o, Class<?> required) {
        Double d;
        if (o instanceof Double) {
            d = (Double)o;
        } else {
            try {
                d = Double.parseDouble(o.toString());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (required == Integer.class || required == Integer.TYPE) {
            return d.intValue();
        }
        if (required == Double.class || required == Double.TYPE) {
            return d;
        }
        if (required == Float.class || required == Float.TYPE) {
            return Float.valueOf(d.floatValue());
        }
        if (required == Long.class || required == Long.TYPE) {
            return d.longValue();
        }
        if (required == Short.class || required == Short.TYPE) {
            return d.shortValue();
        }
        if (required == Byte.class || required == Byte.TYPE) {
            return d.byteValue();
        }
        if (required == Boolean.class || required == Boolean.TYPE) {
            return d != 0.0;
        }
        if (required == Index.class) {
            return Index.toJava(d.intValue(), this.offset);
        }
        return null;
    }
}

