/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.interfaces.oc.providers;

import com.google.common.collect.Maps;
import java.util.Map;
import li.cil.oc.api.driver.Block;
import li.cil.oc.api.network.ManagedEnvironment;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import openmods.Log;
import openperipheral.adapter.TileEntityBlacklist;
import openperipheral.interfaces.oc.ModuleOpenComputers;
import openperipheral.interfaces.oc.providers.IEnviromentInstanceWrapper;

public class DriverOpenPeripheral
implements Block {
    private final Map<Class<?>, Boolean> cache = Maps.newHashMap();

    public boolean worksWith(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null) {
            return false;
        }
        Class<?> cls = te.getClass();
        Boolean result = this.cache.get(cls);
        if (result == null) {
            result = DriverOpenPeripheral.shouldProvide(cls);
            this.cache.put(cls, result);
        }
        return result;
    }

    private static boolean shouldProvide(Class<?> cls) {
        if (TileEntityBlacklist.INSTANCE.isBlacklisted(cls)) {
            return false;
        }
        IEnviromentInstanceWrapper<ManagedEnvironment> factory = ModuleOpenComputers.PERIPHERAL_METHODS_FACTORY.getAdaptedClass(cls);
        return !factory.isEmpty();
    }

    public ManagedEnvironment createEnvironment(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null) {
            Log.warn((String)"Trying to provide environment for %d,%d,%d in world %d, but TE not found", (Object[])new Object[]{x, y, z, world.field_73011_w.field_76574_g});
            return null;
        }
        IEnviromentInstanceWrapper<ManagedEnvironment> adaptedClass = ModuleOpenComputers.PERIPHERAL_METHODS_FACTORY.getAdaptedClass(te.getClass());
        return adaptedClass.createEnvironment(te);
    }
}

