/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.interfaces.oc.providers;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Set;
import openmods.Log;
import openmods.injector.InjectedClassesManager;
import openperipheral.adapter.AdapterRegistry;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.composed.ComposedMethodsFactory;
import openperipheral.adapter.composed.IMethodMap;
import openperipheral.adapter.composed.IndexedMethodMap;
import openperipheral.api.peripheral.ExposeInterface;
import openperipheral.interfaces.oc.asm.ICodeGenerator;
import openperipheral.interfaces.oc.asm.MethodsStore;
import openperipheral.interfaces.oc.providers.IEnviromentInstanceWrapper;
import openperipheral.util.NameUtils;

public class EnvironmentMethodsFactory<T>
extends ComposedMethodsFactory<IEnviromentInstanceWrapper<T>> {
    private static final BytecodeClassLoader fallbackClassLoader = new BytecodeClassLoader();
    private final IEnviromentInstanceWrapper<T> DUMMY = new IEnviromentInstanceWrapper<T>(){

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public T createEnvironment(Object target) {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void visitMethods(IMethodMap.IMethodVisitor visitor) {
        }

        @Override
        public byte[] getClassBytes() {
            return null;
        }
    };
    private final ICodeGenerator generator;
    private final String classProviderId;

    public EnvironmentMethodsFactory(AdapterRegistry adapters, Predicate<IMethodExecutor> selector, String classProviderId, ICodeGenerator generator) {
        super(adapters, selector);
        this.generator = generator;
        this.classProviderId = classProviderId;
    }

    @Override
    protected IEnviromentInstanceWrapper<T> wrapMethods(Class<?> targetCls, Map<String, IMethodExecutor> methods) {
        if (methods.isEmpty()) {
            return this.DUMMY;
        }
        IndexedMethodMap methodMap = new IndexedMethodMap(methods);
        ExposeInterface intfAnnotation = targetCls.getAnnotation(ExposeInterface.class);
        ImmutableSet exposedInterfaces = intfAnnotation != null ? EnvironmentMethodsFactory.getInterfaces(targetCls, intfAnnotation.value()) : ImmutableSet.of();
        String obfTargetClass = NameUtils.grumize(targetCls);
        String generatedClassName = InjectedClassesManager.instance.createClassName(this.classProviderId, obfTargetClass);
        int methodsId = MethodsStore.drop(methodMap.getMethods());
        byte[] bytes = this.generator.generate(generatedClassName, targetCls, (Set<Class<?>>)exposedInterfaces, methodMap, methodsId);
        return new Wrapper(generatedClassName, bytes, targetCls, methods);
    }

    private static Set<Class<?>> getInterfaces(Class<?> targetClass, Class<?>[] value) {
        ImmutableSet result = ImmutableSet.copyOf((Object[])value);
        for (Class intf : result) {
            Preconditions.checkArgument((boolean)intf.isAssignableFrom(targetClass), (Object)"Class %s tries to expose interface %s, but does not implement it");
        }
        return result;
    }

    private static class Wrapper<T>
    implements IEnviromentInstanceWrapper<T> {
        private final String generatedClsName;
        private final byte[] bytes;
        private final Class<?> targetCls;
        private final Map<String, IMethodExecutor> methods;
        private Constructor<? extends T> ctor;

        public Wrapper(String generatedClsName, byte[] bytes, Class<?> targetCls, Map<String, IMethodExecutor> methods) {
            this.generatedClsName = generatedClsName;
            this.bytes = bytes;
            this.targetCls = targetCls;
            this.methods = methods;
        }

        private Class<?> defineClass() throws Exception {
            try {
                return Class.forName(this.generatedClsName);
            }
            catch (ClassNotFoundException e) {
                Log.severe((Throwable)e, (String)"Failed to load %s via transformer injection, will use class loader. State restoring may be broken", (Object[])new Object[]{this.generatedClsName});
                return fallbackClassLoader.define(this.generatedClsName, this.bytes);
            }
        }

        private Constructor<? extends T> getConstructor() {
            if (this.ctor == null) {
                try {
                    Class<?> cls = this.defineClass();
                    this.ctor = cls.getConstructor(this.targetCls);
                }
                catch (Throwable t) {
                    throw Throwables.propagate((Throwable)t);
                }
            }
            return this.ctor;
        }

        @Override
        public T createEnvironment(Object target) {
            try {
                return this.getConstructor().newInstance(target);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return this.methods.size();
        }

        @Override
        public void visitMethods(IMethodMap.IMethodVisitor visitor) {
            for (Map.Entry<String, IMethodExecutor> e : this.methods.entrySet()) {
                visitor.visit(e.getKey(), e.getValue());
            }
        }

        @Override
        public byte[] getClassBytes() {
            return this.bytes;
        }
    }

    private static class BytecodeClassLoader
    extends ClassLoader {
        private final Map<String, Class<?>> cache = Maps.newHashMap();

        private BytecodeClassLoader() {
            super(BytecodeClassLoader.class.getClassLoader());
        }

        public synchronized Class<?> define(String name, byte[] data) {
            Class<?> cls = this.cache.get(name);
            if (cls == null) {
                cls = this.defineClass(name, data, 0, data.length);
                this.cache.put(name, cls);
            }
            return cls;
        }
    }
}

