/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.mod.client.gui.friends;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.api.PlayerAction;
import ftb.lib.api.client.GlStateManager;
import ftb.lib.api.friends.ILMPlayer;
import ftb.lib.api.gui.GuiLM;
import ftb.lib.api.gui.PlayerActionRegistry;
import ftb.utils.api.guide.GuidePage;
import ftb.utils.mod.client.gui.friends.GuidePlayerActionLine;
import ftb.utils.mod.client.gui.friends.GuidePlayerViewLine;
import ftb.utils.mod.client.gui.guide.ButtonGuidePage;
import ftb.utils.mod.client.gui.guide.GuiGuide;
import ftb.utils.net.ClientAction;
import ftb.utils.world.LMPlayerClient;
import ftb.utils.world.LMWorldClient;

@SideOnly(value=Side.CLIENT)
public class GuideFriendsGUIPage
extends GuidePage {
    public final LMPlayerClient playerLM;

    public GuideFriendsGUIPage(LMPlayerClient p) {
        super(p.getProfile().getName());
        this.playerLM = p;
    }

    @Override
    public void onClientDataChanged() {
        this.clear();
        this.text.add(new GuidePlayerViewLine((GuidePage)this, this.playerLM));
        if (!this.playerLM.clientInfo.isEmpty()) {
            for (String s : this.playerLM.clientInfo) {
                this.printlnText(s);
            }
            this.text.add(null);
        }
        for (PlayerAction a : PlayerActionRegistry.getPlayerActions((PlayerAction.Type)PlayerAction.Type.OTHER, (ILMPlayer)LMWorldClient.inst.clientPlayer, (ILMPlayer)this.playerLM, (boolean)true, (boolean)true)) {
            this.text.add(new GuidePlayerActionLine(this, this.playerLM, a));
        }
    }

    @Override
    public ButtonGuidePage createButton(GuiGuide gui) {
        return new Button(gui, this);
    }

    private class Button
    extends ButtonGuidePage {
        public Button(GuiGuide g, GuideFriendsGUIPage p) {
            super(g, p);
            this.height = 20;
        }

        @Override
        public void updateTitle() {
            this.title = GuideFriendsGUIPage.this.playerLM.getProfile().getName();
            this.hover = null;
            if (this.gui.getFontRenderer().func_78256_a(this.title) > this.width - 24) {
                this.hover = this.title + "";
                this.title = this.gui.getFontRenderer().func_78269_a(this.title, this.width - 22) + "...";
            }
        }

        @Override
        public void onButtonPressed(int b) {
            ClientAction.REQUEST_PLAYER_INFO.send(GuideFriendsGUIPage.this.playerLM.getPlayerID());
            super.onButtonPressed(b);
        }

        @Override
        public void renderWidget() {
            int ay = this.getAY();
            if (ay < -this.height || ay > this.guiGuide.mainPanel.height) {
                return;
            }
            int ax = this.getAX();
            double z = this.gui.getZLevel();
            if (this.mouseOver()) {
                GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
                GuiLM.drawBlankRect((double)ax, (double)ay, (double)z, (double)this.width, (double)this.height);
            }
            boolean raw1 = GuideFriendsGUIPage.this.playerLM.isFriendRaw(LMWorldClient.inst.clientPlayer);
            boolean raw2 = LMWorldClient.inst.clientPlayer.isFriendRaw(GuideFriendsGUIPage.this.playerLM);
            GlStateManager.color((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            if (raw1 && raw2) {
                GlStateManager.color((float)0.18f, (float)0.74f, (float)0.18f, (float)1.0f);
            } else if (raw1) {
                GlStateManager.color((float)0.87f, (float)0.74f, (float)0.0f, (float)1.0f);
            } else if (raw2) {
                GlStateManager.color((float)0.0f, (float)0.71f, (float)0.92f, (float)1.0f);
            }
            GuiLM.drawBlankRect((double)(ax + 1), (double)(ay + 1), (double)z, (double)18.0, (double)18.0);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiLM.drawPlayerHead((String)GuideFriendsGUIPage.this.playerLM.getProfile().getName(), (double)(ax + 2), (double)(ay + 2), (double)16.0, (double)16.0, (double)z);
            this.gui.getFontRenderer().func_78276_b(this.title, ax + 22, ay + 6, GuideFriendsGUIPage.this.playerLM.isOnline() ? -15597807 : -1);
        }
    }
}

