/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.guis.module.inpipe;

import java.io.IOException;
import logisticspipes.gui.GuiSupplierPipe;
import logisticspipes.modules.ModuleActiveSupplier;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractguis.GuiProvider;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.utils.gui.DummyContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;

public class ActiveSupplierSlot
extends ModuleCoordinatesGuiProvider {
    private boolean patternUpgarde;
    private int[] slotArray;
    private boolean isLimit;
    private int mode;

    public ActiveSupplierSlot(int id) {
        super(id);
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeBoolean(this.patternUpgarde);
        data.writeIntegerArray(this.slotArray);
        data.writeBoolean(this.isLimit);
        data.writeInt(this.mode);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        super.readData(data);
        this.patternUpgarde = data.readBoolean();
        this.slotArray = data.readIntegerArray();
        this.isLimit = data.readBoolean();
        this.mode = data.readInt();
    }

    @Override
    public Object getClientGui(EntityPlayer player) {
        ModuleActiveSupplier module = this.getLogisticsModule(player.func_130014_f_(), ModuleActiveSupplier.class);
        if (module == null) {
            return null;
        }
        module.setLimited(this.isLimit);
        if (this.patternUpgarde) {
            module.setPatternMode(ModuleActiveSupplier.PatternMode.values()[this.mode]);
        } else {
            module.setSupplyMode(ModuleActiveSupplier.SupplyMode.values()[this.mode]);
        }
        return new GuiSupplierPipe((IInventory)player.field_71071_by, module.getDummyInventory(), module, this.patternUpgarde, this.slotArray);
    }

    @Override
    public DummyContainer getContainer(EntityPlayer player) {
        ModuleActiveSupplier module = this.getLogisticsModule(player.func_130014_f_(), ModuleActiveSupplier.class);
        if (module == null) {
            return null;
        }
        DummyContainer dummy = new DummyContainer((IInventory)player.field_71071_by, module.getDummyInventory());
        dummy.addNormalSlotsForPlayerInventory(18, 97);
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                dummy.addDummySlot(column + row * 3, 72 + column * 18, 18 + row * 18);
            }
        }
        return dummy;
    }

    @Override
    public GuiProvider template() {
        return new ActiveSupplierSlot(this.getId());
    }

    public boolean isPatternUpgarde() {
        return this.patternUpgarde;
    }

    public ActiveSupplierSlot setPatternUpgarde(boolean patternUpgarde) {
        this.patternUpgarde = patternUpgarde;
        return this;
    }

    public int[] getSlotArray() {
        return this.slotArray;
    }

    public ActiveSupplierSlot setSlotArray(int[] slotArray) {
        this.slotArray = slotArray;
        return this;
    }

    public boolean isLimit() {
        return this.isLimit;
    }

    public ActiveSupplierSlot setLimit(boolean isLimit) {
        this.isLimit = isLimit;
        return this;
    }

    public int getMode() {
        return this.mode;
    }

    public ActiveSupplierSlot setMode(int mode) {
        this.mode = mode;
        return this;
    }
}

