/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import java.io.IOException;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.ForgeDirection;

public class PipePositionPacket
extends CoordinatesPacket {
    private int travelId;
    private float speed;
    private float position;
    private ForgeDirection input;
    private ForgeDirection output;

    public PipePositionPacket(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsTileGenericPipe tile = this.getPipe(player.func_130014_f_(), CoordinatesPacket.LTGPCompletionCheck.TRANSPORT);
        if (tile == null || tile.pipe == null || tile.pipe.transport == null) {
            return;
        }
        tile.pipe.transport.handleItemPositionPacket(this.travelId, this.input, this.output, this.speed, this.position);
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeInt(this.travelId);
        data.writeFloat(this.speed);
        data.writeFloat(this.position);
        data.writeForgeDirection(this.input);
        data.writeForgeDirection(this.output);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        super.readData(data);
        this.travelId = data.readInt();
        this.speed = data.readFloat();
        this.position = data.readFloat();
        this.input = data.readForgeDirection();
        this.output = data.readForgeDirection();
    }

    @Override
    public ModernPacket template() {
        return new PipePositionPacket(this.getId());
    }

    public int getTravelId() {
        return this.travelId;
    }

    public PipePositionPacket setTravelId(int travelId) {
        this.travelId = travelId;
        return this;
    }

    public float getSpeed() {
        return this.speed;
    }

    public PipePositionPacket setSpeed(float speed) {
        this.speed = speed;
        return this;
    }

    public float getPosition() {
        return this.position;
    }

    public PipePositionPacket setPosition(float position) {
        this.position = position;
        return this;
    }

    public ForgeDirection getInput() {
        return this.input;
    }

    public PipePositionPacket setInput(ForgeDirection input) {
        this.input = input;
        return this;
    }

    public ForgeDirection getOutput() {
        return this.output;
    }

    public PipePositionPacket setOutput(ForgeDirection output) {
        this.output = output;
        return this;
    }
}

