/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import java.io.IOException;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.modules.ModuleActiveSupplier;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.abstractpackets.ModuleCoordinatesPacket;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.SidedInventoryMinecraftAdapter;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;

public class SlotFinderNumberPacket
extends ModuleCoordinatesPacket {
    private int pipePosX;
    private int pipePosY;
    private int pipePosZ;
    private int inventorySlot;
    private int slot;

    public SlotFinderNumberPacket(int id) {
        super(id);
    }

    @Override
    public ModernPacket template() {
        return new SlotFinderNumberPacket(this.getId());
    }

    @Override
    public void processPacket(EntityPlayer player) {
        int resultIndex;
        IInventory inv = this.getTile(player.field_70170_p, IInventory.class);
        if (inv instanceof ISidedInventory) {
            inv = new SidedInventoryMinecraftAdapter((ISidedInventory)inv, ForgeDirection.UNKNOWN, false);
        }
        IInventoryUtil util = SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(inv);
        Slot result = null;
        if (((Slot)player.field_71070_bA.field_75151_b.get((int)this.inventorySlot)).field_75222_d == this.inventorySlot) {
            result = (Slot)player.field_71070_bA.field_75151_b.get(this.inventorySlot);
        }
        if (result == null) {
            for (Slot slotObject : player.field_71070_bA.field_75151_b) {
                if (slotObject.field_75222_d != this.inventorySlot) continue;
                result = slotObject;
                break;
            }
        }
        if (result == null) {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("lp.chat.slotnotfound", new Object[0]));
        }
        if ((resultIndex = -1) == -1) {
            ItemStack content = result.func_75211_c();
            if (content != null) {
                for (int i = 0; i < util.getSizeInventory(); ++i) {
                    if (content != util.getStackInSlot(i)) continue;
                    resultIndex = i;
                    break;
                }
            } else {
                int i;
                ItemStack dummyStack = new ItemStack(Blocks.field_150348_b, 0, 0);
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("LPStackFinderBoolean", true);
                dummyStack.func_77982_d(nbt);
                result.func_75215_d(dummyStack);
                for (i = 0; i < util.getSizeInventory(); ++i) {
                    if (dummyStack != util.getStackInSlot(i)) continue;
                    resultIndex = i;
                    break;
                }
                if (resultIndex == -1) {
                    for (i = 0; i < util.getSizeInventory(); ++i) {
                        ItemStack stack = util.getStackInSlot(i);
                        if (stack == null || !ItemIdentifier.get(stack).equals(ItemIdentifier.get(dummyStack)) || stack.field_77994_a != dummyStack.field_77994_a) continue;
                        resultIndex = i;
                        break;
                    }
                }
                result.func_75215_d(null);
            }
        }
        if (resultIndex == -1) {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("lp.chat.slotnotfound", new Object[0]));
        } else {
            this.setPosX(this.getPipePosX());
            this.setPosY(this.getPipePosY());
            this.setPosZ(this.getPipePosZ());
            ModuleActiveSupplier module = this.getLogisticsModule(player, ModuleActiveSupplier.class);
            if (module != null) {
                module.slotArray[this.slot] = resultIndex;
            }
        }
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeInt(this.inventorySlot);
        data.writeInt(this.slot);
        data.writeInt(this.pipePosX);
        data.writeInt(this.pipePosY);
        data.writeInt(this.pipePosZ);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        super.readData(data);
        this.inventorySlot = data.readInt();
        this.slot = data.readInt();
        this.pipePosX = data.readInt();
        this.pipePosY = data.readInt();
        this.pipePosZ = data.readInt();
    }

    public int getPipePosX() {
        return this.pipePosX;
    }

    public SlotFinderNumberPacket setPipePosX(int pipePosX) {
        this.pipePosX = pipePosX;
        return this;
    }

    public int getPipePosY() {
        return this.pipePosY;
    }

    public SlotFinderNumberPacket setPipePosY(int pipePosY) {
        this.pipePosY = pipePosY;
        return this;
    }

    public int getPipePosZ() {
        return this.pipePosZ;
    }

    public SlotFinderNumberPacket setPipePosZ(int pipePosZ) {
        this.pipePosZ = pipePosZ;
        return this;
    }

    public SlotFinderNumberPacket setInventorySlot(int inventorySlot) {
        this.inventorySlot = inventorySlot;
        return this;
    }

    public int getSlot() {
        return this.slot;
    }

    public SlotFinderNumberPacket setSlot(int slot) {
        this.slot = slot;
        return this;
    }
}

